/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Document;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.ShadowElementCtrl;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.BeforeCompose;
import org.zkoss.zk.ui.impl.DesktopImpl;
import org.zkoss.zk.ui.impl.PageImpl;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.util.Composer;

public abstract class AbstractUiFactory
implements UiFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractUiFactory.class);

    @Override
    public void start(WebApp wapp) {
    }

    @Override
    public void stop(WebApp wapp) {
    }

    @Override
    public boolean isRichlet(RequestInfo ri, boolean bRichlet) {
        return bRichlet;
    }

    @Override
    public Richlet getRichlet(RequestInfo ri, String path) {
        return ri.getWebApp().getConfiguration().getRichletByPath(path);
    }

    @Override
    public Desktop newDesktop(RequestInfo ri, String updateURI, String path) {
        return this.newDesktop(ri, updateURI, updateURI, path);
    }

    @Override
    public Desktop newDesktop(RequestInfo ri, String updateURI, String resourceURI, String path) {
        int k;
        String deviceType = null;
        if (path != null && (k = path.lastIndexOf(46) + 1) > 0 && path.indexOf(47, k) < 0 && k < path.length()) {
            String ext = path.substring(k);
            try {
                deviceType = LanguageDefinition.getByExtension(ext).getDeviceType();
            }
            catch (DefinitionNotFoundException definitionNotFoundException) {
                // empty catch block
            }
        }
        return new DesktopImpl(ri.getWebApp(), updateURI, resourceURI, path, deviceType, ri.getNativeRequest());
    }

    @Override
    public Page newPage(RequestInfo ri, PageDefinition pagedef, String path) {
        return new PageImpl(pagedef);
    }

    @Override
    public Page newPage(RequestInfo ri, Richlet richlet, String path) {
        return new PageImpl(richlet, path);
    }

    @Override
    public Component newComponent(Page page, Component parent, ShadowInfo compInfo, Component insertBefore) {
        Component comp = compInfo.newInstance(page, parent);
        Utils.setShadowInfo(comp, compInfo);
        Object currentInfo = ShadowElementsCtrl.getCurrentInfo();
        if (currentInfo instanceof ShadowElement && ((ShadowElementCtrl)currentInfo).getShadowHostIfAny() == parent) {
            ((Component)currentInfo).insertBefore(comp, insertBefore);
        } else if (parent instanceof ShadowElement) {
            parent.insertBefore(comp, insertBefore);
        } else if (parent != null) {
            ((ShadowElementCtrl)((Object)comp)).setShadowHost(parent, insertBefore);
        } else {
            Component emptyRoot = null;
            String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.ShadowDefaultHost.class");
            if (clsnm != null) {
                try {
                    emptyRoot = (Component)Classes.newInstanceByThread((String)clsnm);
                    emptyRoot.setPage(page);
                    ((ShadowElementCtrl)((Object)comp)).setShadowHost(emptyRoot, insertBefore);
                }
                catch (Throwable ex) {
                    log.warn("Unable to load " + clsnm, ex);
                }
            }
        }
        if (comp instanceof BeforeCompose) {
            ((BeforeCompose)((Object)comp)).beforeCompose();
        }
        compInfo.applyProperties(comp);
        Utils.setShadowInfo(comp, null);
        return comp;
    }

    @Override
    public Component newComponent(Page page, Component parent, ComponentInfo compInfo, Component insertBefore) {
        Component comp = compInfo.newInstance(page, parent);
        Utils.setComponentInfo(comp, compInfo);
        if (parent != null) {
            parent.insertBefore(comp, insertBefore);
        } else {
            comp.setPageBefore(page, insertBefore);
        }
        if (comp instanceof BeforeCompose) {
            ((BeforeCompose)((Object)comp)).beforeCompose();
        }
        compInfo.applyProperties(comp);
        Utils.setComponentInfo(comp, null);
        return comp;
    }

    @Override
    public Component newComponent(Page page, Component parent, ComponentDefinition compdef, String clsnm) {
        Component comp = compdef.newInstance(page, clsnm);
        if (parent != null) {
            comp.setParent(parent);
        } else {
            comp.setPage(page);
        }
        comp.applyProperties();
        return comp;
    }

    @Override
    public Composer newComposer(Page page, Class klass) {
        if (!Composer.class.isAssignableFrom(klass)) {
            throw new UiException(klass + " must implement " + Composer.class);
        }
        try {
            return (Composer)klass.newInstance();
        }
        catch (Throwable ex) {
            throw UiException.Aide.wrap(ex, "Unable to instantiate " + klass);
        }
    }

    @Override
    public Composer newComposer(Page page, String className) throws ClassNotFoundException {
        return this.newComposer(page, page != null ? page.resolveClass(className) : Classes.forNameByThread((String)className));
    }

    @Override
    public ServerPush newServerPush(Desktop desktop, Class klass) {
        if (!ServerPush.class.isAssignableFrom(klass)) {
            throw new UiException(klass + " must implement " + ServerPush.class);
        }
        try {
            return (ServerPush)klass.newInstance();
        }
        catch (Throwable ex) {
            throw UiException.Aide.wrap(ex, "Unable to instantiate " + klass);
        }
    }

    @Override
    public PageDefinition getPageDefinition(RequestInfo ri, String path) {
        return PageDefinitions.getPageDefinition(ri.getWebApp(), ri.getLocator(), path);
    }

    @Override
    public PageDefinition getPageDefinitionDirectly(RequestInfo ri, String content, String extension) {
        return PageDefinitions.getPageDefinitionDirectly(ri.getWebApp(), ri.getLocator(), content, extension);
    }

    @Override
    public PageDefinition getPageDefinitionDirectly(RequestInfo ri, Document content, String extension) {
        return PageDefinitions.getPageDefinitionDirectly(ri.getWebApp(), ri.getLocator(), content, extension);
    }

    @Override
    public PageDefinition getPageDefinitionDirectly(RequestInfo ri, Reader reader, String extension) throws IOException {
        return PageDefinitions.getPageDefinitionDirectly(ri.getWebApp(), ri.getLocator(), reader, extension);
    }
}

