/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.model.SBook;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.CellSelectionEvent;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class CellSelectionCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)CellSelectionCommand.class.getCanonicalName());
        }
        Map data = request.getData();
        if (data == null || data.size() != 6) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        String sheetId = (String)data.get("sheetId");
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        if (!CellSelectionCommand.getSheetUuid(sheet).equals(sheetId)) {
            return;
        }
        SBook book = ((SheetImpl)sheet).getNative().getBook();
        int maxcol = book.getMaxColumnIndex();
        int maxrow = book.getMaxRowIndex();
        String t = (String)data.get("type");
        CellSelectionType type = null;
        if ("all".equals(t)) {
            type = CellSelectionType.ALL;
        } else if ("col".equals(t)) {
            type = CellSelectionType.COLUMN;
        } else if ("row".equals(t)) {
            type = CellSelectionType.ROW;
        } else if ("cell".equals(t)) {
            type = CellSelectionType.CELL;
        } else {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        int left = (Integer)data.get("left");
        int top = (Integer)data.get("top");
        int right = type == CellSelectionType.ROW || type == CellSelectionType.ALL ? maxcol : (Integer)data.get("right");
        int bottom = type == CellSelectionType.COLUMN || type == CellSelectionType.ALL ? maxrow : (Integer)data.get("bottom");
        SpreadsheetInCtrl ctrl = (SpreadsheetInCtrl)((Spreadsheet)comp).getExtraCtrl();
        ctrl.setSelectionRect(left, top, right, bottom);
        ctrl.setSelType(type);
        Events.postEvent((Event)new CellSelectionEvent("onCellSelection", comp, sheet, top, left, bottom, right, type));
    }
}

