/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import io.keikai.model.chart.SChartData;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.ChartAxisImpl;
import io.keikai.model.impl.chart.ChartDataAdv;
import io.keikai.model.impl.chart.GeneralChartDataImpl;
import io.keikai.model.impl.chart.UnsupportedChartDataImpl;
import io.keikai.model.util.Validations;
import java.util.ArrayList;
import java.util.List;

public class ChartImpl
extends AbstractChartAdv {
    private static final long serialVersionUID = 1L;
    private String _id;
    private SChart.ChartType _type;
    private ViewAnchor _anchor;
    private ChartDataAdv _data;
    private String _title;
    private String _xAxisTitle;
    private String _yAxisTitle;
    private AbstractSheetAdv _sheet;
    private SChart.ChartLegendPosition _legendPosition;
    private SChart.ChartGrouping _grouping;
    private SChart.BarDirection _direction;
    private boolean _threeD;
    private boolean _rAngAx = true;
    private int _rotX = 0;
    private int _rotY = 0;
    private int _hPercent = 100;
    private int _depthPercent = 100;
    private int _perspective = 30;
    private int _barOverlap = 0;
    private boolean _plotOnlyVisibleCells = true;
    private List<SChartAxis> _valueAxises = new ArrayList<SChartAxis>();
    private List<SChartAxis> _categoryAxises = new ArrayList<SChartAxis>();

    public ChartImpl(AbstractSheetAdv sheet, String id, SChart.ChartType type, ViewAnchor anchor) {
        this._sheet = sheet;
        this._id = id;
        this._type = type;
        this._anchor = anchor;
        this._data = this.createChartData(type);
        Validations.argNotNull(anchor);
        switch (type) {
            case BAR: {
                this._direction = SChart.BarDirection.HORIZONTAL;
                break;
            }
            case COLUMN: {
                this._direction = SChart.BarDirection.VERTICAL;
            }
        }
    }

    @Override
    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public ViewAnchor getAnchor() {
        return this._anchor;
    }

    @Override
    public void setAnchor(ViewAnchor anchor) {
        Validations.argNotNull(anchor);
        this._anchor = anchor;
    }

    @Override
    public SChart.ChartType getType() {
        return this._type;
    }

    @Override
    public SChartData getData() {
        return this._data;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public String getXAxisTitle() {
        return this._xAxisTitle;
    }

    @Override
    public void setXAxisTitle(String xAxisTitle) {
        this._xAxisTitle = xAxisTitle;
    }

    @Override
    public String getYAxisTitle() {
        return this._yAxisTitle;
    }

    @Override
    public void setYAxisTitle(String yAxisTitle) {
        this._yAxisTitle = yAxisTitle;
    }

    private ChartDataAdv createChartData(SChart.ChartType type) {
        switch (type) {
            case BAR: 
            case COLUMN: 
            case AREA: 
            case LINE: 
            case DOUGHNUT: 
            case PIE: 
            case SCATTER: 
            case BUBBLE: 
            case STOCK: {
                return new GeneralChartDataImpl(this, this._id + "-data");
            }
            case OF_PIE: 
            case RADAR: 
            case SURFACE: {
                return new UnsupportedChartDataImpl(this);
            }
        }
        throw new UnsupportedOperationException("unsupported chart type " + (Object)((Object)type));
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        ((ChartDataAdv)this.getData()).destroy();
        this._sheet = null;
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public void setLegendPosition(SChart.ChartLegendPosition pos) {
        this._legendPosition = pos;
    }

    @Override
    public SChart.ChartLegendPosition getLegendPosition() {
        return this._legendPosition;
    }

    @Override
    public void setGrouping(SChart.ChartGrouping grouping) {
        this._grouping = grouping;
    }

    @Override
    public SChart.ChartGrouping getGrouping() {
        return this._grouping;
    }

    @Override
    public SChart.BarDirection getBarDirection() {
        return this._direction;
    }

    @Override
    public void setBarDirection(SChart.BarDirection direction) {
        this._direction = direction;
    }

    @Override
    public boolean isThreeD() {
        return this._threeD;
    }

    @Override
    public void setThreeD(boolean threeD) {
        this._threeD = threeD;
    }

    ChartImpl cloneChartImpl(AbstractSheetAdv sheet) {
        ChartImpl tgt = new ChartImpl(sheet, this._id, this._type, this._anchor.cloneViewAnchor());
        if (tgt._data instanceof GeneralChartDataImpl) {
            ((GeneralChartDataImpl)tgt._data).copyFrom((GeneralChartDataImpl)this._data);
        }
        tgt._title = this._title;
        tgt._xAxisTitle = this._xAxisTitle;
        tgt._yAxisTitle = this._yAxisTitle;
        tgt._legendPosition = this._legendPosition;
        tgt._grouping = this._grouping;
        tgt._direction = this._direction;
        tgt._threeD = this._threeD;
        for (SChartAxis axis : this._valueAxises) {
            tgt.addValueAxis(((ChartAxisImpl)axis).cloneChartAxisImpl());
        }
        for (SChartAxis axis : this._categoryAxises) {
            tgt.addCategoryAxis(((ChartAxisImpl)axis).cloneChartAxisImpl());
        }
        return tgt;
    }

    @Override
    public void addValueAxis(SChartAxis axis) {
        this._valueAxises.add(axis);
    }

    @Override
    public void addCategoryAxis(SChartAxis axis) {
        this._categoryAxises.add(axis);
    }

    @Override
    public List<SChartAxis> getValueAxises() {
        return this._valueAxises;
    }

    @Override
    public List<SChartAxis> getCategoryAxises() {
        return this._categoryAxises;
    }

    @Override
    public int getRotX() {
        return this._rotX;
    }

    @Override
    public void setRotX(int rotX) {
        this._rotX = rotX;
    }

    @Override
    public int getRotY() {
        return this._rotY;
    }

    @Override
    public void setRotY(int rotY) {
        this._rotY = rotY;
    }

    @Override
    public int getPerspective() {
        return this._perspective;
    }

    @Override
    public void setPerspective(int perspective) {
        this._perspective = perspective;
    }

    @Override
    public int getHPercent() {
        return this._hPercent;
    }

    @Override
    public void setHPercent(int percent) {
        this._hPercent = percent;
    }

    @Override
    public int getDepthPercent() {
        return this._depthPercent;
    }

    @Override
    public void setDepthPercent(int percent) {
        this._depthPercent = percent;
    }

    @Override
    public boolean isRightAngleAxes() {
        return this._rAngAx;
    }

    @Override
    public void setRightAngleAxes(boolean b) {
        this._rAngAx = b;
    }

    @Override
    public int getBarOverlap() {
        return this._barOverlap;
    }

    @Override
    public void setBarOverlap(int overlap) {
        this._barOverlap = overlap;
    }

    @Override
    public void setPlotOnlyVisibleCells(boolean plotOnlyVisibleCells) {
        this._plotOnlyVisibleCells = plotOnlyVisibleCells;
    }

    @Override
    public boolean isPlotOnlyVisibleCells() {
        return this._plotOnlyVisibleCells;
    }
}

