/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.theme;

import java.util.Comparator;
import org.zkoss.web.theme.Theme;

public final class SpreadsheetStandardTheme
extends Theme {
    public static final String DEFAULT_NAME = "default";
    public static final String DEFAULT_DISPLAY = "Default";
    public static final int DEFAULT_PRIORITY = 500;
    public static final ThemeOrigin DEFAULT_ORIGIN = ThemeOrigin.JAR;
    private String _displayName;
    private int _priority;
    private ThemeOrigin _origin;
    private static final Comparator<SpreadsheetStandardTheme> _COMPARATOR = new Comparator<SpreadsheetStandardTheme>(){

        @Override
        public int compare(SpreadsheetStandardTheme t1, SpreadsheetStandardTheme t2) {
            if (t1 == null) {
                if (t2 == null) {
                    return 0;
                }
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            return t1._priority - t2._priority;
        }
    };

    public SpreadsheetStandardTheme() {
        super(DEFAULT_NAME);
    }

    public SpreadsheetStandardTheme(String themeName) {
        this(themeName, themeName, 500, DEFAULT_ORIGIN);
    }

    public SpreadsheetStandardTheme(String themeName, ThemeOrigin origin) {
        this(themeName, themeName, 500, origin);
    }

    public SpreadsheetStandardTheme(String themeName, String displayName, int priority) {
        this(themeName, displayName, priority, DEFAULT_ORIGIN);
    }

    public SpreadsheetStandardTheme(String themeName, String displayName, int priority, ThemeOrigin origin) {
        if ("".equals(themeName)) {
            throw new IllegalArgumentException("Standard themes should not have blank names");
        }
        super.setName(themeName);
        this._displayName = displayName;
        this._priority = priority;
        this._origin = origin;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public ThemeOrigin getOrigin() {
        return this._origin;
    }

    public static Comparator<SpreadsheetStandardTheme> getComparator() {
        return _COMPARATOR;
    }

    public static enum ThemeOrigin {
        JAR,
        FOLDER;

    }
}

