/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import java.util.LinkedHashMap;
import org.zkoss.poi.hssf.record.FullColorExt;
import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class XFExtRecord
extends StandardRecord {
    public static final short sid = 2173;
    private FtrHeader futureHeader;
    private short reserved1;
    private short ixfe;
    private short reserved2;
    private LinkedHashMap<Short, ExtProp> rgexts;

    public XFExtRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2173);
        this.reserved2 = 0;
        this.reserved1 = 0;
        this.rgexts = new LinkedHashMap();
    }

    @Override
    public short getSid() {
        return 2173;
    }

    public XFExtRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.reserved1 = in.readShort();
        this.ixfe = (short)in.readUShort();
        this.reserved2 = in.readShort();
        int cexts = in.readUShort();
        this.rgexts = new LinkedHashMap(cexts);
        for (int j = 0; j < cexts; ++j) {
            this.addExtProp(in);
        }
    }

    private void addExtProp(RecordInputStream in) {
        ExtProp extProp = new ExtProp(in);
        this.rgexts.put(extProp.getExtType(), extProp);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[XFEXT]\n");
        sb.append("  .ixfe =").append(this.ixfe).append("\n");
        sb.append("  .cexts=").append(this.getCexts()).append("\n");
        for (ExtProp extProp : this.rgexts.values()) {
            sb.append("  .ExtProps = ").append(this.toExtPropName(extProp.getExtType())).append("(").append(HexDump.shortToHex(extProp.getExtType())).append(")\n");
            extProp.appendString(sb, "    ");
        }
        sb.append("[/XFEXT]\n");
        return sb.toString();
    }

    private String toExtPropName(short type) {
        switch (type) {
            case 4: {
                return "FOREGROUND_COLOR";
            }
            case 5: {
                return "BACKGROUND_COLOR";
            }
            case 6: {
                return "GRADIENT";
            }
            case 7: {
                return "TOP_BORDER_COLOR";
            }
            case 8: {
                return "BOTTOM_BORDER_COLOR";
            }
            case 9: {
                return "LEFT_BORDER_COLOR";
            }
            case 10: {
                return "RIGHT_BORDER_COLOR";
            }
            case 11: {
                return "DIAG_BORDER_COLOR";
            }
            case 13: {
                return "TEXT_COLOR";
            }
            case 14: {
                return "FONT_SCHEME";
            }
            case 15: {
                return "TEXT_INDENTION";
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeShort(this.reserved1);
        out.writeShort(this.ixfe);
        out.writeShort(this.reserved2);
        out.writeShort((short)this.getCexts());
        for (ExtProp extProp : this.rgexts.values()) {
            extProp.serialize(out);
        }
    }

    public void cloneXFExtFrom(XFExtRecord source) {
        this.rgexts.putAll(source.rgexts);
    }

    @Override
    protected int getDataSize() {
        int result = 20;
        for (ExtProp extProp : this.rgexts.values()) {
            result += extProp.getDataSize();
        }
        return result;
    }

    public int getIxfe() {
        return this.ixfe;
    }

    public void setIxfe(int ixfe) {
        this.ixfe = (short)ixfe;
    }

    public int getCexts() {
        return this.rgexts.size();
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    public FullColorExt getFillForegroundColor() {
        ExtProp extProp = this.rgexts.get((short)4);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setFillForegroundColor(FullColorExt color) {
        this.addExtProp(new ExtProp(4, color));
    }

    private void addExtProp(ExtProp extProp) {
        this.rgexts.put(extProp.getExtType(), extProp);
    }

    public FullColorExt getFillBackgroundColor() {
        ExtProp extProp = this.rgexts.get((short)5);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setFillBackgroundColor(FullColorExt color) {
        this.addExtProp(new ExtProp(5, color));
    }

    public XFExtGradient getGradientFill() {
        ExtProp extProp = this.rgexts.get((short)6);
        return extProp != null ? (XFExtGradient)extProp.getExtPropData() : null;
    }

    public void setFillGradientFill(XFExtGradient color) {
        this.addExtProp(new ExtProp(6, color));
    }

    public FullColorExt getTopBorderColor() {
        ExtProp extProp = this.rgexts.get((short)7);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setTopBorderColor(FullColorExt color) {
        this.addExtProp(new ExtProp(7, color));
    }

    public FullColorExt getBottomBorderColor() {
        ExtProp extProp = this.rgexts.get((short)8);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setBottomBorderColor(FullColorExt color) {
        this.addExtProp(new ExtProp(8, color));
    }

    public FullColorExt getLeftBorderColor() {
        ExtProp extProp = this.rgexts.get((short)9);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setLeftBorderColor(FullColorExt color) {
        this.addExtProp(new ExtProp(9, color));
    }

    public FullColorExt getRightBorderColor() {
        ExtProp extProp = this.rgexts.get((short)10);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setRightBorderColor(FullColorExt color) {
        this.addExtProp(new ExtProp(10, color));
    }

    public FullColorExt getDiagonalBorderColor() {
        ExtProp extProp = this.rgexts.get((short)11);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setDiagonalBorderColor(FullColorExt color) {
        this.addExtProp(new ExtProp(11, color));
    }

    public FullColorExt getTextColor() {
        ExtProp extProp = this.rgexts.get((short)13);
        return this.getFullColorExt(extProp != null ? (FullColorExt)extProp.getExtPropData() : null);
    }

    public void setTextColor(FullColorExt color) {
        this.addExtProp(new ExtProp(13, color));
    }

    private FullColorExt getFullColorExt(FullColorExt ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getXclrType() == 0 || ext.getXclrType() == 4) {
            return null;
        }
        return ext;
    }

    public Byte getFontScheme() {
        ExtProp extProp = this.rgexts.get((short)14);
        return extProp != null ? (Byte)extProp.getExtPropData() : null;
    }

    public void setFontScheme(Byte scheme) {
        this.addExtProp(new ExtProp(14, scheme));
    }

    public Byte getIndentLevel() {
        ExtProp extProp = this.rgexts.get((short)15);
        return extProp != null ? (Byte)extProp.getExtPropData() : null;
    }

    public void setIndentLevel(Byte indent) {
        this.addExtProp(new ExtProp(15, indent));
    }

    private static class GradStop {
        private static final int DATA_SIZE = 22;
        private short xclrType;
        private int xclrValue;
        private double numPosition;
        private double numTint;

        public GradStop(RecordInputStream in) {
            this.xclrType = in.readShort();
            this.xclrValue = in.readInt();
            this.numPosition = in.readDouble();
            this.numTint = in.readDouble();
        }

        public void toString(StringBuffer sb, String prefix) {
            sb.append(prefix).append(".xclrType   =").append(this.xclrType).append("\n");
            sb.append(prefix).append(".xclrValue  =").append(this.xclrValue).append("\n");
            sb.append(prefix).append(".numPosition=").append(this.numPosition).append("\n");
            sb.append(prefix).append(".numTint    =").append(this.numTint).append("\n");
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this.xclrType);
            out.writeInt(this.xclrValue);
            out.writeDouble(this.numPosition);
            out.writeDouble(this.numTint);
        }

        public int getDataSize() {
            return 22;
        }
    }

    private static class XFPropGradient {
        private static final int DATA_SIZE = 44;
        private int type;
        private double numDegree;
        private double numFillToLeft;
        private double numFillToRight;
        private double numFillToTop;
        private double numFillToBottom;

        public XFPropGradient(RecordInputStream in) {
            this.type = in.readInt();
            this.numDegree = in.readDouble();
            this.numFillToLeft = in.readDouble();
            this.numFillToRight = in.readDouble();
            this.numFillToTop = in.readDouble();
            this.numFillToBottom = in.readDouble();
        }

        public int getDataSize() {
            return 44;
        }

        public void toString(StringBuffer sb, String prefix) {
            sb.append(prefix).append(".type          =").append(this.type).append("\n");
            sb.append(prefix).append(".numDegree     =").append(this.numDegree).append("\n");
            sb.append(prefix).append(".numFillToLeft =").append(this.numFillToLeft).append("\n");
            sb.append(prefix).append(".numFillToRight=").append(this.numFillToRight).append("\n");
            sb.append(prefix).append(".numFillToTop  =").append(this.numFillToTop).append("\n");
            sb.append(prefix).append(".numFillToBottom=").append(this.numFillToBottom).append("\n");
        }

        public void serialize(LittleEndianOutput out) {
            out.writeInt(this.type);
            out.writeDouble(this.numDegree);
            out.writeDouble(this.numFillToLeft);
            out.writeDouble(this.numFillToRight);
            out.writeDouble(this.numFillToTop);
            out.writeDouble(this.numFillToBottom);
        }
    }

    private static class XFExtGradient {
        private XFPropGradient gradient;
        private int cGradStops;
        private GradStop[] rgGradStops;

        public XFExtGradient(RecordInputStream in) {
            this.gradient = new XFPropGradient(in);
            this.cGradStops = in.readInt();
            this.rgGradStops = new GradStop[this.cGradStops];
            for (int j = 0; j < this.cGradStops; ++j) {
                this.rgGradStops[j] = new GradStop(in);
            }
        }

        public int getDataSize() {
            return this.gradient.getDataSize() + 4 + this.cGradStops * 22;
        }

        public void appendString(StringBuffer sb, String prefix) {
            sb.append(prefix).append(".gradient\n");
            this.gradient.toString(sb, prefix + "  ");
            sb.append(prefix).append(".cGradStops=").append(this.cGradStops).append("\n");
            sb.append(prefix).append(".rgGradStops\n");
            for (int j = 0; j < this.cGradStops; ++j) {
                this.rgGradStops[j].toString(sb, prefix + "  ");
            }
        }

        public void serialize(LittleEndianOutput out) {
            this.gradient.serialize(out);
            out.writeInt(this.cGradStops);
            for (int j = 0; j < this.cGradStops; ++j) {
                this.rgGradStops[j].serialize(out);
            }
        }
    }

    private static class ExtProp {
        private static final short FOREGROUND_COLOR = 4;
        private static final short BACKGROUND_COLOR = 5;
        private static final short GRADIENT = 6;
        private static final short TOP_BORDER_COLOR = 7;
        private static final short BOTTOM_BORDER_COLOR = 8;
        private static final short LEFT_BORDER_COLOR = 9;
        private static final short RIGHT_BORDER_COLOR = 10;
        private static final short DIAG_BORDER_COLOR = 11;
        private static final short TEXT_COLOR = 13;
        private static final short FONT_SCHEME = 14;
        private static final short TEXT_INDENTION = 15;
        private short extType;
        private int cb;
        private Object extPropData;

        private ExtProp(short extType, Object extPropData) {
            this.extType = extType;
            this.extPropData = extPropData;
            this.cb = 4;
            if (extPropData instanceof FullColorExt) {
                this.cb += ((FullColorExt)extPropData).getDataSize();
            } else if (extPropData instanceof XFExtGradient) {
                this.cb += ((XFExtGradient)extPropData).getDataSize();
            } else if (extPropData instanceof Byte) {
                ++this.cb;
            } else {
                throw new RuntimeException("Unknown extPropData. extType:" + extType + ", extPropData:" + extPropData);
            }
        }

        public void appendString(StringBuffer sb, String prefix) {
            sb.append(prefix).append(".extType=").append(HexDump.shortToHex(this.extType)).append("\n");
            sb.append(prefix).append(".cb     =").append(this.cb).append("\n");
            sb.append(prefix).append(".extPropData\n");
            if (this.extPropData instanceof FullColorExt) {
                ((FullColorExt)this.extPropData).appendString(sb, prefix + "  ");
            } else if (this.extPropData instanceof XFExtGradient) {
                ((XFExtGradient)this.extPropData).appendString(sb, prefix + "  ");
            } else if (this.extPropData instanceof Byte) {
                sb.append(prefix + "  ").append(HexDump.byteToHex(((Byte)this.extPropData).byteValue())).append("\n");
            } else {
                sb.append(prefix + "  ").append("Unknown extPropData:" + this.extPropData).append("\n");
            }
        }

        public ExtProp(RecordInputStream in) {
            this.extType = in.readShort();
            this.cb = in.readUShort();
            switch (this.extType) {
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    this.extPropData = new FullColorExt(in);
                    break;
                }
                case 6: {
                    this.extPropData = new XFExtGradient(in);
                    break;
                }
                case 14: 
                case 15: {
                    this.extPropData = in.readByte();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown extType:" + this.extType);
                }
            }
        }

        private int getDataSize() {
            return this.cb;
        }

        private short getExtType() {
            return this.extType;
        }

        private Object getExtPropData() {
            return this.extPropData;
        }

        private void serialize(LittleEndianOutput out) {
            out.writeShort(this.extType);
            out.writeShort(this.cb);
            if (this.extPropData instanceof FullColorExt) {
                ((FullColorExt)this.extPropData).serialize(out);
            } else if (this.extPropData instanceof XFExtGradient) {
                ((XFExtGradient)this.extPropData).serialize(out);
            } else if (this.extPropData instanceof Byte) {
                out.writeByte(((Byte)this.extPropData).byteValue());
            } else {
                throw new RuntimeException("Unknown extPropData:" + this.extPropData);
            }
        }
    }
}

