/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class BasicCompletableFuture<V>
extends InternalCompletableFuture<V> {
    final Future<V> delegate;

    BasicCompletableFuture(Future<V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.ensureResultSet(timeout, unit);
    }

    private Object ensureResultSet(long timeout, TimeUnit unit) throws ExecutionException, CancellationException, TimeoutException {
        Throwable result = null;
        try {
            result = this.delegate.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            ExceptionUtil.sneakyThrow(ex);
        }
        catch (CancellationException | ExecutionException ex) {
            this.completeExceptionally(ex);
            throw ex;
        }
        catch (Throwable t) {
            result = t;
            this.completeExceptionally(t);
            ExceptionUtil.sneakyThrow(t);
        }
        this.complete(result);
        return result;
    }

    @Override
    public boolean isDone() {
        if (this.delegate.isDone()) {
            try {
                this.ensureResultSet(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (CancellationException | ExecutionException | TimeoutException ignored) {
                EmptyStatement.ignore(ignored);
            }
            return true;
        }
        return super.isDone();
    }

    @Override
    public boolean isCancelled() {
        if (this.delegate.isCancelled()) {
            if (!super.isCancelled()) {
                this.cancel(true);
            }
            return true;
        }
        return super.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.delegate.isCancelled()) {
            this.delegate.cancel(mayInterruptIfRunning);
        }
        return super.cancel(mayInterruptIfRunning);
    }
}

