/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.text.SimpleDateFormat;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnvTest
extends AbstractTestCase {
    @Test
    public void testParseVariable() {
        MOrder order = new MOrder(Env.getCtx(), 100, this.getTrxName());
        String summary = order.getSummary();
        Object expr = "@=Summary@";
        String parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)summary, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@=summary@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)summary, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String docNo = order.getDocumentNo();
        expr = "@DocumentNo@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)docNo, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String dateOrdered = DisplayType.getDateFormat((int)MTable.get((int)259).getColumn("DateOrdered").getAD_Reference_ID()).format(order.getDateOrdered());
        expr = "@DateOrdered@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)dateOrdered, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dateOrdered = sdf.format(order.getDateOrdered());
        expr = "@DateOrdered<" + sdf.toPattern() + ">@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)dateOrdered, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String clientId = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Client_ID");
        expr = "@#AD_Client_ID@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)clientId, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String clientName = MClient.get((int)this.getAD_Client_ID()).getName();
        expr = "@#AD_Client_ID<Name>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)clientName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String bpartnerValue = MBPartner.get((Properties)Env.getCtx(), (int)order.getC_BPartner_ID()).getValue();
        expr = "@C_BPartner_ID<Value>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String docStatusName = order.getDocStatusName();
        expr = "@DocStatus<Name>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)docStatusName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
    }
}

