/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.tablepartition;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class TablePartitionTask {
    private MTable table;
    private ProcessInfo pi;
    private Trx trx;
    private ITablePartitionService partitionService;
    private CLogger log = CLogger.getCLogger(this.getClass());

    public TablePartitionTask(MTable table, ProcessInfo pi, ITablePartitionService partitionService) {
        this.table = table;
        this.pi = pi;
        this.partitionService = partitionService;
    }

    public boolean executeTask() {
        String trxName;
        boolean isUpdated;
        boolean isError;
        block9: {
            isError = false;
            isUpdated = false;
            trxName = Trx.createTrxName((String)"TablePartition-");
            this.trx = Trx.get((String)trxName, (boolean)true);
            this.trx.setDisplayName(this.getClass().getName() + "_runProcess");
            try {
                try {
                    this.table.set_TrxName(trxName);
                    this.addLog(Msg.getElement((Properties)Env.getCtx(), (String)"TableName") + ": " + this.table.getTableName());
                    List partitionKeyColumns = this.table.getPartitionKeyColumns(true);
                    if (partitionKeyColumns.isEmpty()) {
                        throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionKeyRequired"));
                    }
                    if (!this.isPartitionedTable() && !this.createPartitionedTable()) {
                        throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"FailedCreatePartitionedTable"));
                    }
                    isUpdated = this.addPartitionAndMigrateData();
                    this.trx.commit();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    isError = true;
                    this.addLog(Msg.getMsg((Properties)Env.getCtx(), (String)"Error") + e.getLocalizedMessage());
                    this.trx.rollback();
                    this.trx.close();
                    this.trx = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.trx.close();
                this.trx = null;
                throw throwable;
            }
            this.trx.close();
            this.trx = null;
        }
        if (!isError && isUpdated && !this.runPostPartitionProcess()) {
            isError = true;
            this.addLog(Msg.getMsg((Properties)Env.getCtx(), (String)"FailedRunPostMigrationData"));
        }
        if (isUpdated) {
            this.table.getTablePartitions(true, trxName);
        }
        return !isError;
    }

    private void addLog(String msg) {
        if (this.pi != null && msg != null) {
            this.pi.addLog(0, null, null, msg);
        }
    }

    private String getTrxName() {
        if (this.trx != null) {
            return this.trx.getTrxName();
        }
        return null;
    }

    private boolean isPartitionedTable() {
        return this.partitionService.isPartitionedTable(this.table, this.getTrxName());
    }

    private boolean createPartitionedTable() {
        return this.partitionService.createPartitionedTable(this.table, this.getTrxName(), this.pi);
    }

    private boolean addPartitionAndMigrateData() {
        return this.partitionService.addPartitionAndMigrateData(this.table, this.getTrxName(), this.pi);
    }

    private boolean runPostPartitionProcess() {
        return this.partitionService.runPostPartitionProcess(this.table, this.getTrxName(), this.pi);
    }
}

