/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;

public class ValidationContextImpl
implements ValidationContext {
    private boolean _valid = true;
    private boolean _localValid = true;
    private String _command;
    private Property _property;
    private Map<String, Property[]> _properties;
    private BindContext _ctx;
    private static final String BASED_VALIDATION_PROPERTIES = "$BASED_VALIDATION_PROPS$";

    public ValidationContextImpl(String command, Property property, Map<String, Property[]> properties, BindContext ctx, boolean valid) {
        this._command = command;
        this._property = property;
        this._properties = properties;
        this._ctx = ctx;
        this._valid = valid;
    }

    @Override
    public BindContext getBindContext() {
        return this._ctx;
    }

    @Override
    public String getCommand() {
        return this._command;
    }

    @Override
    public Map<String, Property[]> getProperties() {
        return this._properties;
    }

    @Override
    public Property[] getProperties(String name) {
        return this._properties.get(name);
    }

    @Override
    public Map<String, Property> getProperties(Object base) {
        HashMap<String, Property> mp;
        if (base == null) {
            throw new IllegalArgumentException("base object is null");
        }
        HashMap<Object, HashMap<String, Property>> m = (HashMap<Object, HashMap<String, Property>>)this._ctx.getAttribute(BASED_VALIDATION_PROPERTIES);
        if (m == null) {
            m = new HashMap<Object, HashMap<String, Property>>();
            this._ctx.setAttribute(BASED_VALIDATION_PROPERTIES, m);
        }
        if ((mp = (HashMap<String, Property>)m.get(base)) != null) {
            return mp;
        }
        mp = new HashMap<String, Property>();
        m.put(base, mp);
        for (Map.Entry<String, Property[]> e : this._properties.entrySet()) {
            for (Property p : e.getValue()) {
                if (!base.equals(p.getBase())) continue;
                mp.put(e.getKey(), p);
            }
        }
        return mp;
    }

    @Override
    public Object getValidatorArg(String key) {
        return this._ctx.getValidatorArg(key);
    }

    @Override
    public Property getProperty() {
        return this._property;
    }

    @Override
    public boolean isValid() {
        return this._valid;
    }

    @Override
    public boolean isLocalValid() {
        return this._localValid;
    }

    @Override
    public void setInvalid() {
        this._localValid = false;
        this._valid = false;
    }
}

