/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.usermodel;

import java.util.Locale;
import org.zkoss.util.Locales;

public class ZssContext {
    private final Locale locale;
    private final int twoDigitYearUpperBound;
    private static final InheritableThreadLocal<ZssContext> _thdLocale = new InheritableThreadLocal();

    public ZssContext(Locale locale, int twoDigitYearUpperBound) {
        this.locale = locale;
        this.twoDigitYearUpperBound = twoDigitYearUpperBound;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getTwoDigitYearUpperBound() {
        return this.twoDigitYearUpperBound;
    }

    public static final ZssContext getCurrent() {
        ZssContext l = (ZssContext)_thdLocale.get();
        return l != null ? l : new ZssContext(Locales.getCurrent(), -1);
    }

    public static final ZssContext setThreadLocal(ZssContext ctx) {
        ZssContext old = (ZssContext)_thdLocale.get();
        _thdLocale.set(ctx);
        return old;
    }

    public static final ZssContext getThreadLocal() {
        return (ZssContext)_thdLocale.get();
    }
}

