/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.zkoss.poi.hssf.record.ArrayRecord;
import org.zkoss.poi.hssf.record.AutoFilterInfoRecord;
import org.zkoss.poi.hssf.record.BOFRecord;
import org.zkoss.poi.hssf.record.BackupRecord;
import org.zkoss.poi.hssf.record.BlankRecord;
import org.zkoss.poi.hssf.record.BookBoolRecord;
import org.zkoss.poi.hssf.record.BookExtRecord;
import org.zkoss.poi.hssf.record.BoolErrRecord;
import org.zkoss.poi.hssf.record.BottomMarginRecord;
import org.zkoss.poi.hssf.record.BoundSheetRecord;
import org.zkoss.poi.hssf.record.CFHeaderRecord;
import org.zkoss.poi.hssf.record.CFRuleRecord;
import org.zkoss.poi.hssf.record.CRNCountRecord;
import org.zkoss.poi.hssf.record.CRNRecord;
import org.zkoss.poi.hssf.record.CalcCountRecord;
import org.zkoss.poi.hssf.record.CalcModeRecord;
import org.zkoss.poi.hssf.record.CodepageRecord;
import org.zkoss.poi.hssf.record.ColumnInfoRecord;
import org.zkoss.poi.hssf.record.Compat12Record;
import org.zkoss.poi.hssf.record.CompressPicturesRecord;
import org.zkoss.poi.hssf.record.ContinueRecord;
import org.zkoss.poi.hssf.record.CountryRecord;
import org.zkoss.poi.hssf.record.DBCellRecord;
import org.zkoss.poi.hssf.record.DConRefRecord;
import org.zkoss.poi.hssf.record.DSFRecord;
import org.zkoss.poi.hssf.record.DVALRecord;
import org.zkoss.poi.hssf.record.DVRecord;
import org.zkoss.poi.hssf.record.DateWindow1904Record;
import org.zkoss.poi.hssf.record.DefaultColWidthRecord;
import org.zkoss.poi.hssf.record.DefaultRowHeightRecord;
import org.zkoss.poi.hssf.record.DeltaRecord;
import org.zkoss.poi.hssf.record.DimensionsRecord;
import org.zkoss.poi.hssf.record.DrawingGroupRecord;
import org.zkoss.poi.hssf.record.DrawingRecord;
import org.zkoss.poi.hssf.record.DrawingSelectionRecord;
import org.zkoss.poi.hssf.record.EOFRecord;
import org.zkoss.poi.hssf.record.ExtSSTRecord;
import org.zkoss.poi.hssf.record.ExtendedFormatRecord;
import org.zkoss.poi.hssf.record.ExternSheetRecord;
import org.zkoss.poi.hssf.record.ExternalNameRecord;
import org.zkoss.poi.hssf.record.FeatHdrRecord;
import org.zkoss.poi.hssf.record.FeatRecord;
import org.zkoss.poi.hssf.record.FilePassRecord;
import org.zkoss.poi.hssf.record.FileSharingRecord;
import org.zkoss.poi.hssf.record.FnGroupCountRecord;
import org.zkoss.poi.hssf.record.FontRecord;
import org.zkoss.poi.hssf.record.FooterRecord;
import org.zkoss.poi.hssf.record.ForceFullCalculationRecord;
import org.zkoss.poi.hssf.record.FormatRecord;
import org.zkoss.poi.hssf.record.FormulaRecord;
import org.zkoss.poi.hssf.record.GridsetRecord;
import org.zkoss.poi.hssf.record.GutsRecord;
import org.zkoss.poi.hssf.record.HCenterRecord;
import org.zkoss.poi.hssf.record.HeaderFooterRecord;
import org.zkoss.poi.hssf.record.HeaderRecord;
import org.zkoss.poi.hssf.record.HideObjRecord;
import org.zkoss.poi.hssf.record.HorizontalPageBreakRecord;
import org.zkoss.poi.hssf.record.HyperlinkRecord;
import org.zkoss.poi.hssf.record.IndexRecord;
import org.zkoss.poi.hssf.record.InterfaceEndRecord;
import org.zkoss.poi.hssf.record.InterfaceHdrRecord;
import org.zkoss.poi.hssf.record.IterationRecord;
import org.zkoss.poi.hssf.record.LabelRecord;
import org.zkoss.poi.hssf.record.LabelSSTRecord;
import org.zkoss.poi.hssf.record.LeftMarginRecord;
import org.zkoss.poi.hssf.record.MMSRecord;
import org.zkoss.poi.hssf.record.MTRSettingsRecord;
import org.zkoss.poi.hssf.record.MergeCellsRecord;
import org.zkoss.poi.hssf.record.MulBlankRecord;
import org.zkoss.poi.hssf.record.MulRKRecord;
import org.zkoss.poi.hssf.record.NameCommentRecord;
import org.zkoss.poi.hssf.record.NameRecord;
import org.zkoss.poi.hssf.record.NoteRecord;
import org.zkoss.poi.hssf.record.NumberRecord;
import org.zkoss.poi.hssf.record.ObjRecord;
import org.zkoss.poi.hssf.record.ObjectProtectRecord;
import org.zkoss.poi.hssf.record.PLVRecord;
import org.zkoss.poi.hssf.record.PaletteRecord;
import org.zkoss.poi.hssf.record.PaneRecord;
import org.zkoss.poi.hssf.record.PasswordRecord;
import org.zkoss.poi.hssf.record.PasswordRev4Record;
import org.zkoss.poi.hssf.record.PrecisionRecord;
import org.zkoss.poi.hssf.record.PrintGridlinesRecord;
import org.zkoss.poi.hssf.record.PrintHeadersRecord;
import org.zkoss.poi.hssf.record.PrintSetupRecord;
import org.zkoss.poi.hssf.record.ProtectRecord;
import org.zkoss.poi.hssf.record.ProtectionRev4Record;
import org.zkoss.poi.hssf.record.RKRecord;
import org.zkoss.poi.hssf.record.RecalcIdRecord;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.RecordFactoryInputStream;
import org.zkoss.poi.hssf.record.RecordFormatException;
import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.RefModeRecord;
import org.zkoss.poi.hssf.record.RefreshAllRecord;
import org.zkoss.poi.hssf.record.RightMarginRecord;
import org.zkoss.poi.hssf.record.RowRecord;
import org.zkoss.poi.hssf.record.SCLRecord;
import org.zkoss.poi.hssf.record.SSTRecord;
import org.zkoss.poi.hssf.record.SaveRecalcRecord;
import org.zkoss.poi.hssf.record.ScenarioProtectRecord;
import org.zkoss.poi.hssf.record.SelectionRecord;
import org.zkoss.poi.hssf.record.SharedFormulaRecord;
import org.zkoss.poi.hssf.record.StringRecord;
import org.zkoss.poi.hssf.record.StyleExtRecord;
import org.zkoss.poi.hssf.record.StyleRecord;
import org.zkoss.poi.hssf.record.SupBookRecord;
import org.zkoss.poi.hssf.record.TabIdRecord;
import org.zkoss.poi.hssf.record.TableRecord;
import org.zkoss.poi.hssf.record.TableStylesRecord;
import org.zkoss.poi.hssf.record.TextObjectRecord;
import org.zkoss.poi.hssf.record.ThemeRecord;
import org.zkoss.poi.hssf.record.TopMarginRecord;
import org.zkoss.poi.hssf.record.UncalcedRecord;
import org.zkoss.poi.hssf.record.UnknownRecord;
import org.zkoss.poi.hssf.record.UseSelFSRecord;
import org.zkoss.poi.hssf.record.UserSViewBegin;
import org.zkoss.poi.hssf.record.UserSViewEnd;
import org.zkoss.poi.hssf.record.VCenterRecord;
import org.zkoss.poi.hssf.record.VerticalPageBreakRecord;
import org.zkoss.poi.hssf.record.WSBoolRecord;
import org.zkoss.poi.hssf.record.WindowOneRecord;
import org.zkoss.poi.hssf.record.WindowProtectRecord;
import org.zkoss.poi.hssf.record.WindowTwoRecord;
import org.zkoss.poi.hssf.record.WriteAccessRecord;
import org.zkoss.poi.hssf.record.WriteProtectRecord;
import org.zkoss.poi.hssf.record.XFCrcRecord;
import org.zkoss.poi.hssf.record.XFExtRecord;
import org.zkoss.poi.hssf.record.chart.AreaFormatRecord;
import org.zkoss.poi.hssf.record.chart.AreaRecord;
import org.zkoss.poi.hssf.record.chart.AxisLineFormatRecord;
import org.zkoss.poi.hssf.record.chart.AxisOptionsRecord;
import org.zkoss.poi.hssf.record.chart.AxisParentRecord;
import org.zkoss.poi.hssf.record.chart.AxisRecord;
import org.zkoss.poi.hssf.record.chart.AxisUsedRecord;
import org.zkoss.poi.hssf.record.chart.BarRecord;
import org.zkoss.poi.hssf.record.chart.BeginRecord;
import org.zkoss.poi.hssf.record.chart.CatLabRecord;
import org.zkoss.poi.hssf.record.chart.CategorySeriesAxisRecord;
import org.zkoss.poi.hssf.record.chart.Chart3DBarShapeRecord;
import org.zkoss.poi.hssf.record.chart.Chart3DRecord;
import org.zkoss.poi.hssf.record.chart.ChartEndBlockRecord;
import org.zkoss.poi.hssf.record.chart.ChartEndObjectRecord;
import org.zkoss.poi.hssf.record.chart.ChartFRTInfoRecord;
import org.zkoss.poi.hssf.record.chart.ChartFormatRecord;
import org.zkoss.poi.hssf.record.chart.ChartRecord;
import org.zkoss.poi.hssf.record.chart.ChartStartBlockRecord;
import org.zkoss.poi.hssf.record.chart.ChartStartObjectRecord;
import org.zkoss.poi.hssf.record.chart.ChartTitleFormatRecord;
import org.zkoss.poi.hssf.record.chart.DatRecord;
import org.zkoss.poi.hssf.record.chart.DataFormatRecord;
import org.zkoss.poi.hssf.record.chart.DefaultDataLabelTextPropertiesRecord;
import org.zkoss.poi.hssf.record.chart.EndRecord;
import org.zkoss.poi.hssf.record.chart.FontBasisRecord;
import org.zkoss.poi.hssf.record.chart.FontIndexRecord;
import org.zkoss.poi.hssf.record.chart.FrameRecord;
import org.zkoss.poi.hssf.record.chart.LegendRecord;
import org.zkoss.poi.hssf.record.chart.LineFormatRecord;
import org.zkoss.poi.hssf.record.chart.LineRecord;
import org.zkoss.poi.hssf.record.chart.LinkedDataRecord;
import org.zkoss.poi.hssf.record.chart.ObjectLinkRecord;
import org.zkoss.poi.hssf.record.chart.PieFormatRecord;
import org.zkoss.poi.hssf.record.chart.PieRecord;
import org.zkoss.poi.hssf.record.chart.PlotAreaRecord;
import org.zkoss.poi.hssf.record.chart.PlotGrowthRecord;
import org.zkoss.poi.hssf.record.chart.ScatterRecord;
import org.zkoss.poi.hssf.record.chart.SeriesIndexRecord;
import org.zkoss.poi.hssf.record.chart.SeriesListRecord;
import org.zkoss.poi.hssf.record.chart.SeriesRecord;
import org.zkoss.poi.hssf.record.chart.SeriesTextRecord;
import org.zkoss.poi.hssf.record.chart.SeriesToChartGroupRecord;
import org.zkoss.poi.hssf.record.chart.SheetPropertiesRecord;
import org.zkoss.poi.hssf.record.chart.TextRecord;
import org.zkoss.poi.hssf.record.chart.TickRecord;
import org.zkoss.poi.hssf.record.chart.ValueRangeRecord;
import org.zkoss.poi.hssf.record.pivottable.DataItemRecord;
import org.zkoss.poi.hssf.record.pivottable.ExtendedPivotTableViewFieldsRecord;
import org.zkoss.poi.hssf.record.pivottable.PageItemRecord;
import org.zkoss.poi.hssf.record.pivottable.StreamIDRecord;
import org.zkoss.poi.hssf.record.pivottable.ViewDefinitionRecord;
import org.zkoss.poi.hssf.record.pivottable.ViewFieldsRecord;
import org.zkoss.poi.hssf.record.pivottable.ViewSourceRecord;

public final class RecordFactory {
    private static final int NUM_RECORDS = 512;
    private static final Class<?>[] CONSTRUCTOR_ARGS = new Class[]{RecordInputStream.class};
    private static final Class<? extends Record>[] recordClasses = new Class[]{AreaFormatRecord.class, AreaRecord.class, ArrayRecord.class, AutoFilterInfoRecord.class, AxisLineFormatRecord.class, AxisOptionsRecord.class, AxisParentRecord.class, AxisRecord.class, AxisUsedRecord.class, BackupRecord.class, BarRecord.class, BlankRecord.class, BOFRecord.class, BookExtRecord.class, BookBoolRecord.class, BoolErrRecord.class, BottomMarginRecord.class, BoundSheetRecord.class, CalcCountRecord.class, CalcModeRecord.class, CategorySeriesAxisRecord.class, CFHeaderRecord.class, CFRuleRecord.class, Chart3DRecord.class, ChartFormatRecord.class, ChartRecord.class, ChartTitleFormatRecord.class, CodepageRecord.class, ColumnInfoRecord.class, Compat12Record.class, CompressPicturesRecord.class, ContinueRecord.class, CountryRecord.class, CRNCountRecord.class, CRNRecord.class, DatRecord.class, DateWindow1904Record.class, DBCellRecord.class, DConRefRecord.class, DefaultColWidthRecord.class, DefaultDataLabelTextPropertiesRecord.class, DefaultRowHeightRecord.class, DeltaRecord.class, DimensionsRecord.class, DrawingGroupRecord.class, DrawingRecord.class, DrawingSelectionRecord.class, DSFRecord.class, DVALRecord.class, DVRecord.class, EOFRecord.class, ExtendedFormatRecord.class, ExternalNameRecord.class, ExternSheetRecord.class, ExtSSTRecord.class, FeatRecord.class, FeatHdrRecord.class, FilePassRecord.class, FileSharingRecord.class, FnGroupCountRecord.class, FontBasisRecord.class, FontIndexRecord.class, FontRecord.class, FooterRecord.class, ForceFullCalculationRecord.class, FormatRecord.class, FormulaRecord.class, FrameRecord.class, GridsetRecord.class, GutsRecord.class, HCenterRecord.class, HeaderRecord.class, HeaderFooterRecord.class, HideObjRecord.class, HorizontalPageBreakRecord.class, HyperlinkRecord.class, IndexRecord.class, InterfaceEndRecord.class, InterfaceHdrRecord.class, IterationRecord.class, LabelRecord.class, LabelSSTRecord.class, LeftMarginRecord.class, LegendRecord.class, LineFormatRecord.class, LineRecord.class, MergeCellsRecord.class, MMSRecord.class, MTRSettingsRecord.class, MulBlankRecord.class, MulRKRecord.class, NameRecord.class, NameCommentRecord.class, NoteRecord.class, NumberRecord.class, ObjectProtectRecord.class, ObjRecord.class, ObjectLinkRecord.class, PaletteRecord.class, PaneRecord.class, PasswordRecord.class, PasswordRev4Record.class, PieRecord.class, PieFormatRecord.class, PlotAreaRecord.class, PlotGrowthRecord.class, PLVRecord.class, PrecisionRecord.class, PrintGridlinesRecord.class, PrintHeadersRecord.class, PrintSetupRecord.class, ProtectionRev4Record.class, ProtectRecord.class, RecalcIdRecord.class, RefModeRecord.class, RefreshAllRecord.class, RightMarginRecord.class, RKRecord.class, RowRecord.class, SCLRecord.class, SaveRecalcRecord.class, ScatterRecord.class, ScenarioProtectRecord.class, SelectionRecord.class, SeriesIndexRecord.class, SeriesListRecord.class, SeriesRecord.class, SeriesTextRecord.class, SharedFormulaRecord.class, SheetPropertiesRecord.class, SSTRecord.class, StringRecord.class, StyleExtRecord.class, StyleRecord.class, SupBookRecord.class, TabIdRecord.class, TableRecord.class, TableStylesRecord.class, TextObjectRecord.class, TextRecord.class, ThemeRecord.class, TickRecord.class, TopMarginRecord.class, UncalcedRecord.class, UseSelFSRecord.class, UserSViewBegin.class, UserSViewEnd.class, ValueRangeRecord.class, VCenterRecord.class, VerticalPageBreakRecord.class, WindowOneRecord.class, WindowProtectRecord.class, WindowTwoRecord.class, WriteAccessRecord.class, WriteProtectRecord.class, WSBoolRecord.class, XFCrcRecord.class, XFExtRecord.class, BeginRecord.class, Chart3DBarShapeRecord.class, ChartFRTInfoRecord.class, ChartStartBlockRecord.class, ChartEndBlockRecord.class, ChartStartObjectRecord.class, ChartEndObjectRecord.class, CatLabRecord.class, DataFormatRecord.class, EndRecord.class, LinkedDataRecord.class, SeriesToChartGroupRecord.class, DataItemRecord.class, ExtendedPivotTableViewFieldsRecord.class, PageItemRecord.class, StreamIDRecord.class, ViewDefinitionRecord.class, ViewFieldsRecord.class, ViewSourceRecord.class};
    private static final Map<Integer, I_RecordCreator> _recordCreatorsById = RecordFactory.recordsToMap(recordClasses);
    private static short[] _allKnownRecordSIDs;

    public static Class<? extends Record> getRecordClass(int sid) {
        I_RecordCreator rc = _recordCreatorsById.get(sid);
        if (rc == null) {
            return null;
        }
        return rc.getRecordClass();
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record record = RecordFactory.createSingleRecord(in);
        if (record instanceof DBCellRecord) {
            return new Record[]{null};
        }
        if (record instanceof RKRecord) {
            return new Record[]{RecordFactory.convertToNumberRecord((RKRecord)record)};
        }
        if (record instanceof MulRKRecord) {
            return RecordFactory.convertRKRecords((MulRKRecord)record);
        }
        return new Record[]{record};
    }

    public static Record createSingleRecord(RecordInputStream in) {
        I_RecordCreator constructor = _recordCreatorsById.get(in.getSid());
        if (constructor == null) {
            return new UnknownRecord(in);
        }
        return constructor.create(in);
    }

    public static NumberRecord convertToNumberRecord(RKRecord rk) {
        NumberRecord num = new NumberRecord();
        num.setColumn(rk.getColumn());
        num.setRow(rk.getRow());
        num.setXFIndex(rk.getXFIndex());
        num.setValue(rk.getRKNumber());
        return num;
    }

    public static NumberRecord[] convertRKRecords(MulRKRecord mrk) {
        NumberRecord[] mulRecs = new NumberRecord[mrk.getNumColumns()];
        for (int k = 0; k < mrk.getNumColumns(); ++k) {
            NumberRecord nr = new NumberRecord();
            nr.setColumn((short)(k + mrk.getFirstColumn()));
            nr.setRow(mrk.getRow());
            nr.setXFIndex(mrk.getXFAt(k));
            nr.setValue(mrk.getRKNumberAt(k));
            mulRecs[k] = nr;
        }
        return mulRecs;
    }

    public static BlankRecord[] convertBlankRecords(MulBlankRecord mbk) {
        BlankRecord[] mulRecs = new BlankRecord[mbk.getNumColumns()];
        for (int k = 0; k < mbk.getNumColumns(); ++k) {
            BlankRecord br = new BlankRecord();
            br.setColumn((short)(k + mbk.getFirstColumn()));
            br.setRow(mbk.getRow());
            br.setXFIndex(mbk.getXFAt(k));
            mulRecs[k] = br;
        }
        return mulRecs;
    }

    public static short[] getAllKnownRecordSIDs() {
        if (_allKnownRecordSIDs == null) {
            short[] results = new short[_recordCreatorsById.size()];
            int i = 0;
            for (Integer sid : _recordCreatorsById.keySet()) {
                results[i++] = sid.shortValue();
            }
            Arrays.sort(results);
            _allKnownRecordSIDs = results;
        }
        return (short[])_allKnownRecordSIDs.clone();
    }

    private static Map<Integer, I_RecordCreator> recordsToMap(Class<? extends Record>[] records) {
        HashMap<Integer, I_RecordCreator> result = new HashMap<Integer, I_RecordCreator>();
        HashSet<Class<? extends Record>> uniqueRecClasses = new HashSet<Class<? extends Record>>(records.length * 3 / 2);
        for (int i = 0; i < records.length; ++i) {
            short sid;
            Class<? extends Record> recClass = records[i];
            if (!Record.class.isAssignableFrom(recClass)) {
                throw new RuntimeException("Invalid record sub-class (" + recClass.getName() + ")");
            }
            if (Modifier.isAbstract(recClass.getModifiers())) {
                throw new RuntimeException("Invalid record class (" + recClass.getName() + ") - must not be abstract");
            }
            if (!uniqueRecClasses.add(recClass)) {
                throw new RuntimeException("duplicate record class (" + recClass.getName() + ")");
            }
            try {
                sid = recClass.getField("sid").getShort(null);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types");
            }
            Integer key = sid;
            if (result.containsKey(key)) {
                Class<? extends Record> prevClass = ((I_RecordCreator)result.get(key)).getRecordClass();
                throw new RuntimeException("duplicate record sid 0x" + Integer.toHexString(sid).toUpperCase() + " for classes (" + recClass.getName() + ") and (" + prevClass.getName() + ")");
            }
            result.put(key, RecordFactory.getRecordCreator(recClass));
        }
        return result;
    }

    private static I_RecordCreator getRecordCreator(Class<? extends Record> recClass) {
        try {
            Constructor<? extends Record> constructor = recClass.getConstructor(CONSTRUCTOR_ARGS);
            return new ReflectionConstructorRecordCreator(constructor);
        }
        catch (NoSuchMethodException constructor) {
            try {
                Method m = recClass.getDeclaredMethod("create", CONSTRUCTOR_ARGS);
                return new ReflectionMethodRecordCreator(m);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to find constructor or create method for (" + recClass.getName() + ").");
            }
        }
    }

    public static List<Record> createRecords(InputStream in) throws RecordFormatException {
        Record record;
        ArrayList<Record> records = new ArrayList<Record>(512);
        RecordFactoryInputStream recStream = new RecordFactoryInputStream(in, true);
        while ((record = recStream.nextRecord()) != null) {
            records.add(record);
        }
        return records;
    }

    private static final class ReflectionMethodRecordCreator
    implements I_RecordCreator {
        private final Method _m;

        public ReflectionMethodRecordCreator(Method m) {
            this._m = m;
        }

        @Override
        public Record create(RecordInputStream in) {
            Object[] args = new Object[]{in};
            try {
                return (Record)this._m.invoke(null, args);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RecordFormatException("Unable to construct record instance", e.getTargetException());
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._m.getDeclaringClass();
        }
    }

    private static final class ReflectionConstructorRecordCreator
    implements I_RecordCreator {
        private final Constructor<? extends Record> _c;

        public ReflectionConstructorRecordCreator(Constructor<? extends Record> c) {
            this._c = c;
        }

        @Override
        public Record create(RecordInputStream in) {
            Object[] args = new Object[]{in};
            try {
                return this._c.newInstance(args);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RecordFormatException("Unable to construct record instance", e.getTargetException());
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._c.getDeclaringClass();
        }
    }

    private static interface I_RecordCreator {
        public Record create(RecordInputStream var1);

        public Class<? extends Record> getRecordClass();
    }
}

