/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ddf;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.zkoss.poi.ddf.EscherRecordFactory;
import org.zkoss.poi.ddf.EscherSerializationListener;
import org.zkoss.poi.ddf.NullEscherSerializationListener;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.util.LittleEndian;

public abstract class EscherRecord {
    private static BitField fInstance = BitFieldFactory.getInstance(65520);
    private static BitField fVersion = BitFieldFactory.getInstance(15);
    private short _options;
    private short _recordId;

    protected int fillFields(byte[] data, EscherRecordFactory f) {
        return this.fillFields(data, 0, f);
    }

    public abstract int fillFields(byte[] var1, int var2, EscherRecordFactory var3);

    protected int readHeader(byte[] data, int offset) {
        this._options = LittleEndian.getShort(data, offset);
        this._recordId = LittleEndian.getShort(data, offset + 2);
        int remainingBytes = LittleEndian.getInt(data, offset + 4);
        return remainingBytes;
    }

    protected static short readInstance(byte[] data, int offset) {
        short options = LittleEndian.getShort(data, offset);
        return fInstance.getShortValue(options);
    }

    public boolean isContainerRecord() {
        return this.getVersion() == 15;
    }

    @Internal
    public short getOptions() {
        return this._options;
    }

    @Internal
    public void setOptions(short options) {
        this.setVersion(fVersion.getShortValue(options));
        this.setInstance(fInstance.getShortValue(options));
        this._options = options;
    }

    public byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public int serialize(int offset, byte[] data) {
        return this.serialize(offset, data, new NullEscherSerializationListener());
    }

    public abstract int serialize(int var1, byte[] var2, EscherSerializationListener var3);

    public abstract int getRecordSize();

    public short getRecordId() {
        return this._recordId;
    }

    public void setRecordId(short recordId) {
        this._recordId = recordId;
    }

    public List<EscherRecord> getChildRecords() {
        return Collections.emptyList();
    }

    public void setChildRecords(List<EscherRecord> childRecords) {
        throw new UnsupportedOperationException("This record does not support child records.");
    }

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public EscherRecord getChild(int index) {
        return this.getChildRecords().get(index);
    }

    public void display(PrintWriter w, int indent) {
        for (int i = 0; i < indent * 4; ++i) {
            w.print(' ');
        }
        w.println(this.getRecordName());
    }

    public abstract String getRecordName();

    public short getInstance() {
        return fInstance.getShortValue(this._options);
    }

    public void setInstance(short value) {
        this._options = fInstance.setShortValue(this._options, value);
    }

    public short getVersion() {
        return fVersion.getShortValue(this._options);
    }

    public void setVersion(short value) {
        this._options = fVersion.setShortValue(this._options, value);
    }

    public String toXml(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append(tab).append("<").append(this.getClass().getSimpleName()).append(">\n").append(tab).append("\t").append("<RecordId>0x").append(HexDump.toHex(this._recordId)).append("</RecordId>\n").append(tab).append("\t").append("<Options>").append(this._options).append("</Options>\n").append(tab).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return builder.toString();
    }

    protected String formatXmlRecordHeader(String className, String recordId, String version, String instance) {
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(className).append(" recordId=\"0x").append(recordId).append("\" version=\"0x").append(version).append("\" instance=\"0x").append(instance).append("\" size=\"").append(this.getRecordSize()).append("\">\n");
        return builder.toString();
    }

    public String toXml() {
        return this.toXml("");
    }
}

