/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.ModelEvent;
import io.keikai.model.ModelEventListener;
import io.keikai.model.impl.EventListenerAdaptor;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class DirectEventListenerAdaptor
implements EventListenerAdaptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ModelEventListener> listeners = new LinkedList<ModelEventListener>();

    @Override
    public void addEventListener(ModelEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeEventListener(ModelEventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void sendModelEvent(ModelEvent event) {
        for (ModelEventListener l : this.listeners) {
            l.onEvent(event);
        }
    }

    @Override
    public int size() {
        return this.listeners.size();
    }

    @Override
    public void clear() {
        this.listeners.clear();
    }
}

