/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.range.impl.imexp.UnitUtil;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;

public class ImExpUtils {
    public static int getWidthAny(Sheet poiSheet, int col, int charWidth) {
        int w = poiSheet.getColumnWidth(col);
        if (poiSheet instanceof XSSFSheet) {
            if ((double)w == ((XSSFSheet)poiSheet).getXssfDefaultColumnWidth() * 256.0) {
                return UnitUtil.xssfDefaultColumnWidthToPx((double)w / 256.0, charWidth);
            }
        } else if (w == poiSheet.getDefaultColumnWidth() * 256) {
            return UnitUtil.defaultColumnWidthToPx(w / 256, charWidth);
        }
        return UnitUtil.fileChar256ToPx(w, charWidth);
    }

    public static int getHeightAny(Sheet poiSheet, int row) {
        return ImExpUtils.getRowHeightInPx(poiSheet, poiSheet.getRow(row));
    }

    public static int getRowHeightInPx(Sheet poiSheet, Row row) {
        short h;
        short defaultHeight = poiSheet.getDefaultRowHeight();
        short s = h = row == null ? defaultHeight : row.getHeight();
        if (h == 255) {
            h = defaultHeight;
        }
        return UnitUtil.twipToPx(h);
    }
}

