/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import java.lang.reflect.Method;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.NotImplementedException;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.Function;

public class OverridableFunction
implements Function {
    private final String _functionName;
    private final Function _original;
    private Function _func;
    private static Class _funcClass;
    private static String _funcClassName;
    private static String _hasFuncName;

    public OverridableFunction(String name, Function original) {
        this._functionName = name;
        this._original = original;
        if (_funcClass != null) {
            try {
                this._func = (Function)_funcClass.getConstructor(String.class).newInstance(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (this._func != null && this.hasFunction(this._func)) {
            return this._func.evaluate(args, srcRowIndex, srcColumnIndex);
        }
        try {
            return this._original.evaluate(args, srcRowIndex, srcColumnIndex);
        }
        catch (NotImplementedException x) {
            return ErrorEval.NAME_INVALID;
        }
    }

    private boolean hasFunction(Function fn) {
        try {
            Method m = fn.getClass().getMethod(_hasFuncName, new Class[0]);
            Object obj = m.invoke((Object)fn, null);
            return (Boolean)obj;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFunctionName() {
        return this._functionName;
    }

    static {
        _funcClassName = "org.zkoss.zssex.formula.ELEvalFunction";
        _hasFuncName = "hasFunction";
        try {
            Thread.currentThread().getClass();
            _funcClass = Class.forName(_funcClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

