/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.api;

import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.DeferredMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MapBuilder {
    protected final int _features;
    protected final boolean _checkDups;
    protected final Class<?> _mapType;

    protected MapBuilder(int n, Class<?> clazz) {
        this._features = n;
        this._checkDups = JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS.isEnabled(n);
        this._mapType = clazz;
    }

    public static MapBuilder defaultImpl() {
        return new Default(0, null);
    }

    public abstract MapBuilder newBuilder(int var1);

    public abstract MapBuilder newBuilder(Class<?> var1);

    public MapBuilder newBuilder() {
        return this.newBuilder(this._features);
    }

    public final boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public abstract MapBuilder start();

    public abstract MapBuilder put(String var1, Object var2);

    public abstract Map<String, Object> build();

    public Map<String, Object> emptyMap() throws JSONObjectException {
        return this.start().build();
    }

    public Map<String, Object> singletonMap(String string, Object object) throws JSONObjectException {
        return this.start().put(string, object).build();
    }

    public static class Default
    extends MapBuilder {
        protected Map<String, Object> _current;

        protected Default(int n, Class<?> clazz) {
            super(n, clazz);
        }

        @Override
        public MapBuilder newBuilder(int n) {
            return new Default(n, this._mapType);
        }

        @Override
        public MapBuilder newBuilder(Class<?> clazz) {
            return new Default(this._features, clazz);
        }

        @Override
        public MapBuilder start() {
            if (this._current != null) {
                return this.newBuilder().start();
            }
            this._current = this._map(12);
            return this;
        }

        @Override
        public Map<String, Object> build() {
            Map<String, Object> map = this._current;
            this._current = null;
            return map;
        }

        @Override
        public MapBuilder put(String string, Object object) {
            if (this._checkDups && this._current.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate key (key '" + string + "')");
            }
            this._current.put(string, object);
            return this;
        }

        @Override
        public Map<String, Object> emptyMap() {
            if (this._mapType == null && this.isEnabled(JSON.Feature.READ_ONLY)) {
                return Collections.emptyMap();
            }
            return this._map(4);
        }

        private final Map<String, Object> _map(int n) {
            if (this._mapType != null) {
                try {
                    Map map = (Map)this._mapType.getDeclaredConstructor(new Class[0]).newInstance(null);
                    return map;
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    while (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    throw new IllegalArgumentException("Failed to create an instance of " + this._mapType.getName() + " (" + throwable.getClass().getName() + "): " + throwable.getMessage());
                }
            }
            boolean bl = this.isEnabled(JSON.Feature.PRESERVE_FIELD_ORDERING);
            if (this.isEnabled(JSON.Feature.USE_DEFERRED_MAPS)) {
                return new DeferredMap(bl, n);
            }
            return bl ? new LinkedHashMap(n) : new HashMap(n);
        }
    }
}

