/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class TaskDefinition<V>
implements IdentifiedDataSerializable {
    private Type type;
    private String name;
    private Callable<V> command;
    private long initialDelay;
    private long period;
    private TimeUnit unit;
    private boolean autoDisposable;

    public TaskDefinition() {
    }

    public TaskDefinition(Type type, String name, Callable<V> command, long delay, TimeUnit unit, boolean autoDisposable) {
        this.type = type;
        this.name = name;
        this.command = command;
        this.initialDelay = delay;
        this.unit = unit;
        this.autoDisposable = autoDisposable;
    }

    public TaskDefinition(Type type, String name, Callable<V> command, long initialDelay, long period, TimeUnit unit, boolean autoDisposable) {
        this.type = type;
        this.name = name;
        this.command = command;
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.autoDisposable = autoDisposable;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Callable<V> getCommand() {
        return this.command;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean isAutoDisposable() {
        return this.autoDisposable;
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.type.name());
        out.writeString(this.name);
        out.writeObject(this.command);
        out.writeLong(this.initialDelay);
        out.writeLong(this.period);
        out.writeString(this.unit.name());
        if (out.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            out.writeBoolean(this.autoDisposable);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.type = Type.valueOf(in.readString());
        this.name = in.readString();
        this.command = (Callable)in.readObject();
        this.initialDelay = in.readLong();
        this.period = in.readLong();
        this.unit = TimeUnit.valueOf(in.readString());
        if (in.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            this.autoDisposable = in.readBoolean();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.initialDelay == that.initialDelay && this.period == that.period && this.type == that.type && this.name.equals(that.name) && this.unit == that.unit && this.autoDisposable == that.autoDisposable;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.name, this.initialDelay, this.period, this.unit, this.autoDisposable});
    }

    public String toString() {
        return "TaskDefinition{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", command=" + this.command + ", initialDelay=" + this.initialDelay + ", period=" + this.period + ", unit=" + (Object)((Object)this.unit) + ", autoDisposable=" + this.autoDisposable + '}';
    }

    public static enum Type {
        SINGLE_RUN(0),
        AT_FIXED_RATE(1);

        private final byte id;

        private Type(int status) {
            this.id = (byte)status;
        }

        public byte getId() {
            return this.id;
        }

        public static Type getById(int id) {
            for (Type as : Type.values()) {
                if (as.getId() != id) continue;
                return as;
            }
            throw new IllegalArgumentException("Unsupported ID value");
        }
    }
}

