/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.UUID;

public class TxnDeleteBackupOperation
extends RemoveBackupOperation {
    private UUID transactionId;

    public TxnDeleteBackupOperation() {
    }

    public TxnDeleteBackupOperation(String name, Data dataKey, UUID transactionId) {
        super(name, dataKey, false);
        this.transactionId = transactionId;
    }

    @Override
    protected void runInternal() {
        boolean exist = this.recordStore.existInMemory(this.dataKey);
        this.recordStore.removeBackupTxn(this.dataKey, this.getCallerProvenance(), this.transactionId);
        this.recordStore.forceUnlock(this.dataKey);
        if (!exist) {
            this.wbqCapacityCounter().decrement(this.transactionId);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 142;
    }
}

