/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.config.Config;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class StorageInfoCollector
implements MetricsCollector {
    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        NodeEngineImpl nodeEngine = node.getNodeEngine();
        Config config = nodeEngine.getConfig();
        this.memory(metricsConsumer, config, node.getNodeExtension());
        this.tieredStorage(metricsConsumer, config);
        this.dataMemoryCost(metricsConsumer, nodeEngine);
    }

    private void memory(BiConsumer<PhoneHomeMetrics, String> metricsConsumer, Config config, NodeExtension nodeExtension) {
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        boolean isHdEnabled = nativeMemoryConfig.isEnabled();
        metricsConsumer.accept(PhoneHomeMetrics.HD_MEMORY_ENABLED, String.valueOf(isHdEnabled));
        MemoryStats memoryStats = nodeExtension.getMemoryStats();
        if (isHdEnabled) {
            long offHeapMemorySize = memoryStats.getUsedNative();
            metricsConsumer.accept(PhoneHomeMetrics.MEMORY_USED_NATIVE_SIZE, String.valueOf(offHeapMemorySize));
        }
        metricsConsumer.accept(PhoneHomeMetrics.MEMORY_USED_HEAP_SIZE, String.valueOf(memoryStats.getUsedHeap()));
        metricsConsumer.accept(PhoneHomeMetrics.MEMORY_FREE_HEAP_SIZE, String.valueOf(memoryStats.getFreeHeap()));
    }

    private void tieredStorage(BiConsumer<PhoneHomeMetrics, String> metricsConsumer, Config config) {
        boolean tieredStorageEnabled = config.getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
        metricsConsumer.accept(PhoneHomeMetrics.TIERED_STORAGE_ENABLED, String.valueOf(tieredStorageEnabled));
    }

    private void dataMemoryCost(BiConsumer<PhoneHomeMetrics, String> metricsConsumer, NodeEngine nodeEngine) {
        MapService mapService = (MapService)nodeEngine.getService("hz:impl:mapService");
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)nodeEngine.getService("hz:impl:replicatedMapService");
        long totalEntryMemoryCost = Stream.concat(mapService.getStats().values().stream(), replicatedMapService.getStats().values().stream()).mapToLong(LocalMapStats::getOwnedEntryMemoryCost).sum();
        metricsConsumer.accept(PhoneHomeMetrics.DATA_MEMORY_COST, String.valueOf(totalEntryMemoryCost));
    }
}

