/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.collection;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FixedCapacityArrayList<E>
extends AbstractList<E> {
    private E[] elementData;
    private int size;

    public FixedCapacityArrayList(Class<E> eClass, int initialCapacity) {
        this.elementData = (Object[])Array.newInstance(eClass, initialCapacity);
    }

    @Override
    public boolean add(E e) {
        ++this.modCount;
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public E get(int index) {
        return this.elementData[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public E[] asArray() {
        E[] result = this.size == this.elementData.length ? this.elementData : Arrays.copyOfRange(this.elementData, 0, this.size);
        this.elementData = null;
        return result;
    }
}

