/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.function.SupplierEx;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class HostnameUtil {
    public static final int PROCESS_TIMEOUT_IN_SECONDS = 5;

    private HostnameUtil() {
    }

    public static String getLocalHostname() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null) {
            hostname = HostnameUtil.getOrNull(HostnameUtil::execHostnameCmd);
        }
        if (hostname == null) {
            hostname = HostnameUtil.getOrNull(() -> InetAddress.getLocalHost().getHostName());
        }
        return HostnameUtil.shortHostname(hostname);
    }

    @Nonnull
    private static String execHostnameCmd() throws Exception {
        Process exec = Runtime.getRuntime().exec("hostname");
        exec.waitFor(5L, TimeUnit.SECONDS);
        InputStream stream = exec.getInputStream();
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }

    private static String shortHostname(String hostname) {
        if (hostname == null) {
            return null;
        }
        if (hostname.contains(".")) {
            hostname = hostname.substring(0, hostname.indexOf("."));
        }
        return hostname;
    }

    private static String getOrNull(SupplierEx<String> supplierEx) {
        try {
            return supplierEx.getEx();
        }
        catch (Exception e) {
            return null;
        }
    }
}

