/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.ReactorBuilder;
import com.hazelcast.internal.tpcengine.TpcEngine;
import com.hazelcast.internal.tpcengine.nio.NioReactorBuilder;
import com.hazelcast.internal.tpcengine.util.Preconditions;

public class TpcEngineBuilder {
    public static final String NAME_REACTOR_COUNT = "hazelcast.tpc.reactor.count";
    int reactorCount = Integer.getInteger("hazelcast.tpc.reactor.count", Runtime.getRuntime().availableProcessors());
    ReactorBuilder reactorBuilder = new NioReactorBuilder();

    public TpcEngineBuilder setReactorBuilder(ReactorBuilder reactorBuilder) {
        this.reactorBuilder = Preconditions.checkNotNull(reactorBuilder, "reactorBuilder");
        return this;
    }

    public TpcEngineBuilder setReactorCount(int reactorCount) {
        this.reactorCount = Preconditions.checkPositive(reactorCount, "reactorCount");
        return this;
    }

    public TpcEngine build() {
        return new TpcEngine(this);
    }
}

