/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.FieldTypeToFieldKind;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeserializedPortableGenericRecord
extends PortableGenericRecord {
    private final ClassDefinition classDefinition;
    private final Object[] objects;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DeserializedPortableGenericRecord(ClassDefinition classDefinition, Object[] objects) {
        this.classDefinition = classDefinition;
        this.objects = objects;
    }

    @Override
    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        return GenericRecordBuilder.portable(this.classDefinition);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilderWithClone() {
        return new PortableGenericRecordBuilder(this.classDefinition, Arrays.copyOf(this.objects, this.objects.length));
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.classDefinition.getFieldNames();
    }

    @Override
    public GenericRecord[] getArrayOfGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord[])this.get(fieldName, FieldType.PORTABLE_ARRAY);
    }

    @Override
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.get(fieldName, FieldType.PORTABLE);
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.classDefinition.hasField(fieldName);
    }

    @Override
    @Nonnull
    public FieldKind getFieldKind(@Nonnull String fieldName) {
        FieldType fieldType;
        try {
            fieldType = this.classDefinition.getFieldType(fieldName);
        }
        catch (IllegalArgumentException ignored) {
            return FieldKind.NOT_AVAILABLE;
        }
        return FieldTypeToFieldKind.toFieldKind(fieldType);
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        return (Boolean)this.get(fieldName, FieldType.BOOLEAN);
    }

    @Override
    public byte getInt8(@Nonnull String fieldName) {
        return (Byte)this.get(fieldName, FieldType.BYTE);
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        return ((Character)this.get(fieldName, FieldType.CHAR)).charValue();
    }

    @Override
    public double getFloat64(@Nonnull String fieldName) {
        return (Double)this.get(fieldName, FieldType.DOUBLE);
    }

    @Override
    public float getFloat32(@Nonnull String fieldName) {
        return ((Float)this.get(fieldName, FieldType.FLOAT)).floatValue();
    }

    @Override
    public int getInt32(@Nonnull String fieldName) {
        return (Integer)this.get(fieldName, FieldType.INT);
    }

    @Override
    public long getInt64(@Nonnull String fieldName) {
        return (Long)this.get(fieldName, FieldType.LONG);
    }

    @Override
    public short getInt16(@Nonnull String fieldName) {
        return (Short)this.get(fieldName, FieldType.SHORT);
    }

    @Override
    @Nullable
    public String getString(@Nonnull String fieldName) {
        return (String)this.get(fieldName, FieldType.UTF);
    }

    @Override
    @Nullable
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return (BigDecimal)this.get(fieldName, FieldType.DECIMAL);
    }

    @Override
    @Nullable
    public LocalTime getTime(@Nonnull String fieldName) {
        return (LocalTime)this.get(fieldName, FieldType.TIME);
    }

    @Override
    @Nullable
    public LocalDate getDate(@Nonnull String fieldName) {
        return (LocalDate)this.get(fieldName, FieldType.DATE);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        return (LocalDateTime)this.get(fieldName, FieldType.TIMESTAMP);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        return (OffsetDateTime)this.get(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nullable
    public boolean[] getArrayOfBoolean(@Nonnull String fieldName) {
        return (boolean[])this.get(fieldName, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    @Nullable
    public byte[] getArrayOfInt8(@Nonnull String fieldName) {
        return (byte[])this.get(fieldName, FieldType.BYTE_ARRAY);
    }

    @Override
    @Nullable
    public char[] getArrayOfChar(@Nonnull String fieldName) {
        return (char[])this.get(fieldName, FieldType.CHAR_ARRAY);
    }

    @Override
    @Nullable
    public double[] getArrayOfFloat64(@Nonnull String fieldName) {
        return (double[])this.get(fieldName, FieldType.DOUBLE_ARRAY);
    }

    @Override
    @Nullable
    public float[] getArrayOfFloat32(@Nonnull String fieldName) {
        return (float[])this.get(fieldName, FieldType.FLOAT_ARRAY);
    }

    @Override
    @Nullable
    public int[] getArrayOfInt32(@Nonnull String fieldName) {
        return (int[])this.get(fieldName, FieldType.INT_ARRAY);
    }

    @Override
    @Nullable
    public long[] getArrayOfInt64(@Nonnull String fieldName) {
        return (long[])this.get(fieldName, FieldType.LONG_ARRAY);
    }

    @Override
    @Nullable
    public short[] getArrayOfInt16(@Nonnull String fieldName) {
        return (short[])this.get(fieldName, FieldType.SHORT_ARRAY);
    }

    @Override
    @Nullable
    public String[] getArrayOfString(@Nonnull String fieldName) {
        return (String[])this.get(fieldName, FieldType.UTF_ARRAY);
    }

    @Override
    @Nullable
    public BigDecimal[] getArrayOfDecimal(@Nonnull String fieldName) {
        return (BigDecimal[])this.get(fieldName, FieldType.DECIMAL_ARRAY);
    }

    @Override
    @Nullable
    public LocalTime[] getArrayOfTime(@Nonnull String fieldName) {
        return (LocalTime[])this.get(fieldName, FieldType.TIME_ARRAY);
    }

    @Override
    @Nullable
    public LocalDate[] getArrayOfDate(@Nonnull String fieldName) {
        return (LocalDate[])this.get(fieldName, FieldType.DATE_ARRAY);
    }

    @Override
    @Nullable
    public LocalDateTime[] getArrayOfTimestamp(@Nonnull String fieldName) {
        return (LocalDateTime[])this.get(fieldName, FieldType.TIMESTAMP_ARRAY);
    }

    @Override
    @Nullable
    public OffsetDateTime[] getArrayOfTimestampWithTimezone(@Nonnull String fieldName) {
        return (OffsetDateTime[])this.get(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    @Override
    protected Object getClassIdentifier() {
        return this.classDefinition;
    }

    @Override
    @Nullable
    public InternalGenericRecord getInternalGenericRecord(@Nonnull String fieldName) {
        return (InternalGenericRecord)this.get(fieldName, FieldType.PORTABLE);
    }

    @Override
    @Nullable
    public InternalGenericRecord[] getArrayOfInternalGenericRecord(@Nonnull String fieldName) {
        return (InternalGenericRecord[])this.get(fieldName, FieldType.PORTABLE_ARRAY);
    }

    @Override
    @Nullable
    public Boolean getBooleanFromArray(@Nonnull String fieldName, int index) {
        boolean[] array = this.getArrayOfBoolean(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Byte getInt8FromArray(@Nonnull String fieldName, int index) {
        byte[] array = this.getArrayOfInt8(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Character getCharFromArray(@Nonnull String fieldName, int index) {
        char[] array = this.getArrayOfChar(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return Character.valueOf(array[index]);
    }

    @Override
    @Nullable
    public Double getFloat64FromArray(@Nonnull String fieldName, int index) {
        double[] array = this.getArrayOfFloat64(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Float getFloat32FromArray(@Nonnull String fieldName, int index) {
        float[] array = this.getArrayOfFloat32(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return Float.valueOf(array[index]);
    }

    @Override
    @Nullable
    public Integer getInt32FromArray(@Nonnull String fieldName, int index) {
        int[] array = this.getArrayOfInt32(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Long getInt64FromArray(@Nonnull String fieldName, int index) {
        long[] array = this.getArrayOfInt64(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Short getInt16FromArray(@Nonnull String fieldName, int index) {
        short[] array = this.getArrayOfInt16(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public String getStringFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfString(fieldName), index);
    }

    @Override
    @Nullable
    public GenericRecord getGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfGenericRecord(fieldName), index);
    }

    @Override
    @Nullable
    public InternalGenericRecord getInternalGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfInternalGenericRecord(fieldName), index);
    }

    @Nullable
    public Object getObjectFromArray(@Nonnull String fieldName, int index) {
        return this.getGenericRecordFromArray(fieldName, index);
    }

    @Override
    @Nullable
    public <T> T[] getArrayOfObject(@Nonnull String fieldName, Class<T> componentType) {
        return this.getArrayOfGenericRecord(fieldName);
    }

    @Nullable
    public Object getObject(@Nonnull String fieldName) {
        return this.getGenericRecord(fieldName);
    }

    @Override
    @Nullable
    public BigDecimal getDecimalFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfDecimal(fieldName), index);
    }

    @Override
    @Nullable
    public LocalTime getTimeFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfTime(fieldName), index);
    }

    @Override
    @Nullable
    public LocalDate getDateFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfDate(fieldName), index);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestampFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfTimestamp(fieldName), index);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezoneFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfTimestampWithTimezone(fieldName), index);
    }

    private <T> T get(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.check(fieldName, fieldType);
        return (T)this.objects[fd.getIndex()];
    }

    @Nonnull
    private FieldDefinition check(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.classDefinition.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}");
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}, expected : " + (Object)((Object)fd.getType()) + ", given : " + (Object)((Object)fieldType));
        }
        return fd;
    }

    private <T> T getFromArray(T[] array, int index) {
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }
}

