/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterTopologyChangedException;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaDataSerializerHook;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;

public abstract class AbstractSchemaReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    protected int memberListVersion;

    protected AbstractSchemaReplicationOperation() {
    }

    protected AbstractSchemaReplicationOperation(int memberListVersion) {
        this.memberListVersion = memberListVersion;
    }

    protected abstract void runInternal();

    @Override
    public void run() throws Exception {
        this.runInternal();
        this.checkReceivedMemberListVersion();
    }

    private void checkReceivedMemberListVersion() {
        ClusterService clusterService = this.getNodeEngine().getClusterService();
        if (!clusterService.isMaster()) {
            return;
        }
        int currentMemberListVersion = clusterService.getMemberListVersion();
        if (currentMemberListVersion == this.memberListVersion) {
            return;
        }
        throw new ClusterTopologyChangedException("Current member list version " + currentMemberListVersion + " does not match expected " + this.memberListVersion);
    }

    @Override
    public String getServiceName() {
        return "schema-service";
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof ClusterTopologyChangedException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }
}

