/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.monitor.impl.GlobalPerIndexStats;
import com.hazelcast.internal.monitor.impl.HDGlobalIndexOperationStats;
import com.hazelcast.internal.monitor.impl.IndexOperationStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class HDGlobalPerIndexStats
extends GlobalPerIndexStats {
    private static final AtomicLongFieldUpdater<HDGlobalPerIndexStats> MEMORY_COST = AtomicLongFieldUpdater.newUpdater(HDGlobalPerIndexStats.class, "memoryCost");
    private volatile long memoryCost;

    public HDGlobalPerIndexStats(boolean ordered, boolean usesCachedQueryableEntries) {
        super(ordered, usesCachedQueryableEntries);
    }

    @Override
    public long getMemoryCost() {
        return this.memoryCost;
    }

    @Override
    public MemoryAllocator wrapMemoryAllocator(MemoryAllocator memoryAllocator) {
        return new MemoryAllocatorWithStats(memoryAllocator);
    }

    public void updateMemoryCost(long delta) {
        MEMORY_COST.addAndGet(this, delta);
    }

    public void resetMemoryCost() {
        this.memoryCost = 0L;
    }

    @Override
    public IndexOperationStats createOperationStats() {
        return new HDGlobalIndexOperationStats();
    }

    private class MemoryAllocatorWithStats
    implements MemoryAllocator {
        private final MemoryAllocator delegate;

        MemoryAllocatorWithStats(MemoryAllocator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long allocate(long size) {
            long result = this.delegate.allocate(size);
            HDGlobalPerIndexStats.this.updateMemoryCost(size);
            return result;
        }

        @Override
        public long reallocate(long address, long currentSize, long newSize) {
            long result = this.delegate.reallocate(address, currentSize, newSize);
            HDGlobalPerIndexStats.this.updateMemoryCost(newSize - currentSize);
            return result;
        }

        @Override
        public void free(long address, long size) {
            this.delegate.free(address, size);
            HDGlobalPerIndexStats.this.updateMemoryCost(-size);
        }

        @Override
        public void dispose() {
            this.delegate.dispose();
            HDGlobalPerIndexStats.this.resetMemoryCost();
        }
    }
}

