/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class GetLeadedGroupsOp
extends Operation
implements RaftSystemOperation,
IdentifiedDataSerializable {
    private transient Map.Entry<Integer, Collection<CPGroupId>> entry = new AbstractMap.SimpleImmutableEntry(0, Collections.emptyList());

    @Override
    public void run() throws Exception {
        RaftService service = (RaftService)this.getService();
        Collection<CPGroupId> groups = service.getLeadedGroups();
        int cpMemberPriority = service.getCPMemberPriority();
        this.entry = new AbstractMap.SimpleImmutableEntry<Integer, Collection<CPGroupId>>(cpMemberPriority, groups);
    }

    @Override
    public Object getResponse() {
        return this.entry;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 48;
    }
}

