/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.nio.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ConfigStream
extends InputStream {
    static final int DEFAULT_READ_LIMIT_4K = 4096;
    private final InputStream delegateStream;

    public ConfigStream(InputStream configStream) throws IOException {
        this(configStream, 4096);
    }

    public ConfigStream(InputStream configStream, int readLimit) throws IOException {
        this.delegateStream = ConfigStream.useOrCopyConfigStream(configStream, readLimit);
    }

    private static InputStream useOrCopyConfigStream(InputStream configStream, int readLimit) throws IOException {
        if (!configStream.markSupported()) {
            return ConfigStream.copyInputStream(configStream, readLimit);
        }
        try {
            configStream.reset();
            return configStream;
        }
        catch (Exception ex) {
            return ConfigStream.copyInputStream(configStream, readLimit);
        }
    }

    private static InputStream copyInputStream(InputStream configStream, int readLimit) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            IOUtil.drainToLimited(configStream, baos, readLimit);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
    }

    @Override
    public int read() throws IOException {
        return this.delegateStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegateStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegateStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegateStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegateStream.available();
    }

    @Override
    public void close() throws IOException {
        this.delegateStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegateStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegateStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegateStream.markSupported();
    }
}

