/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNDataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlColumnMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlErrorCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlQueryIdCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.SqlError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class SqlExecute_reservedCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x210100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x210101;
    private static final int REQUEST_TIMEOUT_MILLIS_FIELD_OFFSET = 16;
    private static final int REQUEST_CURSOR_BUFFER_SIZE_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 28;
    private static final int RESPONSE_ROW_PAGE_LAST_FIELD_OFFSET = 13;
    private static final int RESPONSE_UPDATE_COUNT_FIELD_OFFSET = 14;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 22;

    private SqlExecute_reservedCodec() {
    }

    public static ClientMessage encodeRequest(String sql, Collection<Data> parameters, long timeoutMillis, int cursorBufferSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Sql.Execute_reserved");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[28], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x210100);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, timeoutMillis);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, cursorBufferSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, sql);
        ListMultiFrameCodec.encode(clientMessage, parameters, DataCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.timeoutMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.cursorBufferSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.sql = StringCodec.decode(iterator);
        request.parameters = ListMultiFrameCodec.decode(iterator, DataCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable QueryId queryId, @Nullable List<SqlColumnMetadata> rowMetadata, @Nullable Collection<Collection<Data>> rowPage, boolean rowPageLast, long updateCount, @Nullable SqlError error) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[22], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x210101);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, rowPageLast);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 14, updateCount);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, queryId, SqlQueryIdCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, rowMetadata, SqlColumnMetadataCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, rowPage, ListCNDataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, error, SqlErrorCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.rowPageLast = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        response.updateCount = FixedSizeTypesCodec.decodeLong(initialFrame.content, 14);
        response.queryId = CodecUtil.decodeNullable(iterator, SqlQueryIdCodec::decode);
        response.rowMetadata = ListMultiFrameCodec.decodeNullable(iterator, SqlColumnMetadataCodec::decode);
        response.rowPage = ListMultiFrameCodec.decodeNullable(iterator, ListCNDataCodec::decode);
        response.error = CodecUtil.decodeNullable(iterator, SqlErrorCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        @Nullable
        public QueryId queryId;
        @Nullable
        public List<SqlColumnMetadata> rowMetadata;
        @Nullable
        public List<List<Data>> rowPage;
        public boolean rowPageLast;
        public long updateCount;
        @Nullable
        public SqlError error;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String sql;
        public List<Data> parameters;
        public long timeoutMillis;
        public int cursorBufferSize;
    }
}

