/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CacheEntriesWithCursor
implements IdentifiedDataSerializable {
    private List<Map.Entry<Data, Data>> entries;
    private IterationPointer[] pointers;

    public CacheEntriesWithCursor() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public CacheEntriesWithCursor(List<Map.Entry<Data, Data>> entries, IterationPointer[] pointers) {
        this.entries = entries;
        this.pointers = pointers;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This is an internal class")
    public IterationPointer[] getPointers() {
        return this.pointers;
    }

    public List<Map.Entry<Data, Data>> getEntries() {
        return this.entries;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 38;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
        int size = this.entries.size();
        out.writeInt(size);
        for (Map.Entry<Data, Data> entry : this.entries) {
            IOUtil.writeData(out, entry.getKey());
            IOUtil.writeData(out, entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i = 0; i < pointersCount; ++i) {
            this.pointers[i] = new IterationPointer(in.readInt(), in.readInt());
        }
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = IOUtil.readData(in);
            Data value = IOUtil.readData(in);
            this.entries.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
        }
    }

    public String toString() {
        return "CacheEntryIteratorResult";
    }

    public int getCount() {
        return this.entries != null ? this.entries.size() : 0;
    }
}

