/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

import com.hazelcast.jet.JetException;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;

public final class LinTrendAccumulator {
    private static final int MAX_BIGINT_LEN = 255;
    private long n;
    private BigInteger sumX;
    private BigInteger sumY;
    private BigInteger sumXY;
    private BigInteger sumX2;

    public LinTrendAccumulator() {
        this.sumX = BigInteger.ZERO;
        this.sumY = BigInteger.ZERO;
        this.sumXY = BigInteger.ZERO;
        this.sumX2 = BigInteger.ZERO;
    }

    public LinTrendAccumulator(long n, BigInteger sumX, BigInteger sumY, BigInteger sumXY, BigInteger sumX2) {
        this.n = n;
        this.sumX = sumX;
        this.sumY = sumY;
        this.sumXY = sumXY;
        this.sumX2 = sumX2;
    }

    public LinTrendAccumulator accumulate(long x, long y) {
        ++this.n;
        BigInteger bigX = BigInteger.valueOf(x);
        BigInteger bigY = BigInteger.valueOf(y);
        this.sumX = this.sumX.add(bigX);
        this.sumY = this.sumY.add(bigY);
        this.sumXY = this.sumXY.add(bigX.multiply(bigY));
        this.sumX2 = this.sumX2.add(bigX.multiply(bigX));
        return this;
    }

    public LinTrendAccumulator combine(LinTrendAccumulator that) {
        this.n += that.n;
        this.sumX = this.sumX.add(that.sumX);
        this.sumY = this.sumY.add(that.sumY);
        this.sumXY = this.sumXY.add(that.sumXY);
        this.sumX2 = this.sumX2.add(that.sumX2);
        return this;
    }

    public LinTrendAccumulator deduct(LinTrendAccumulator that) {
        this.n -= that.n;
        this.sumX = this.sumX.subtract(that.sumX);
        this.sumY = this.sumY.subtract(that.sumY);
        this.sumXY = this.sumXY.subtract(that.sumXY);
        this.sumX2 = this.sumX2.subtract(that.sumX2);
        return this;
    }

    public double export() {
        BigInteger bigN = BigInteger.valueOf(this.n);
        return bigN.multiply(this.sumXY).subtract(this.sumX.multiply(this.sumY)).doubleValue() / bigN.multiply(this.sumX2).subtract(this.sumX.multiply(this.sumX)).doubleValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinTrendAccumulator)) {
            return false;
        }
        LinTrendAccumulator that = (LinTrendAccumulator)obj;
        return this.n == that.n && Objects.equals(this.sumX, that.sumX) && Objects.equals(this.sumY, that.sumY) && Objects.equals(this.sumXY, that.sumXY) && Objects.equals(this.sumX2, that.sumX2);
    }

    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + Long.hashCode(this.n);
        hc = 73 * hc + Objects.hashCode(this.sumX);
        hc = 73 * hc + Objects.hashCode(this.sumY);
        hc = 73 * hc + Objects.hashCode(this.sumXY);
        hc = 73 * hc + Objects.hashCode(this.sumX2);
        return hc;
    }

    public void writeObject(ObjectDataOutput out) throws IOException {
        out.writeLong(this.n);
        LinTrendAccumulator.writeBytes(out, this.sumX.toByteArray());
        LinTrendAccumulator.writeBytes(out, this.sumY.toByteArray());
        LinTrendAccumulator.writeBytes(out, this.sumXY.toByteArray());
        LinTrendAccumulator.writeBytes(out, this.sumX2.toByteArray());
    }

    private static void writeBytes(ObjectDataOutput out, byte[] bytes) throws IOException {
        if (bytes.length > 255) {
            throw new JetException("BigInteger serialized to " + bytes.length + " bytes, only up to 255 is supported");
        }
        out.write(bytes.length);
        out.write(bytes);
    }
}

