/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import java.util.Objects;

public class LicenseKey {
    private static final int LICENSE_KEY_VISIBLE_CHAR_COUNT = 5;
    private final String licenseKey;

    public LicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getMaskedLicense() {
        return LicenseKey.maskLicense(this.licenseKey);
    }

    public static String maskLicense(String licenseKey) {
        if (licenseKey.length() > 5) {
            String[] licenceKeyParts = licenseKey.split("#");
            String originalKeyPart = licenceKeyParts[licenceKeyParts.length - 1];
            return originalKeyPart.substring(0, 5) + "*********" + originalKeyPart.substring(originalKeyPart.length() - 5);
        }
        return licenseKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseKey that = (LicenseKey)o;
        return Objects.equals(this.licenseKey, that.licenseKey);
    }

    public int hashCode() {
        return this.licenseKey.hashCode();
    }

    public String toString() {
        return "LicenseKey{licenseKey='" + this.getMaskedLicense() + '\'' + '}';
    }
}

