/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.regex.Pattern;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrData;
import org.zkoss.poi.ss.formula.SheetNameFormatter;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;

public class XSSFChartAxDataSource<T>
implements ChartDataSource<T> {
    private CTAxDataSource cat;

    public XSSFChartAxDataSource(CTAxDataSource cat) {
        this.cat = cat;
    }

    @Override
    public int getPointCount() {
        if (this.cat != null) {
            if (this.isNumeric()) {
                if (this.isReference()) {
                    return (int)this.cat.getNumRef().getNumCache().getPtCount().getVal();
                }
                return (int)this.cat.getNumLit().getPtCount().getVal();
            }
            if (this.isReference()) {
                return (int)this.cat.getStrRef().getStrCache().getPtCount().getVal();
            }
            return (int)this.cat.getStrLit().getPtCount().getVal();
        }
        return 0;
    }

    @Override
    public T getPointAt(int index) {
        if (this.cat != null) {
            if (this.isNumeric()) {
                if (this.isReference()) {
                    return (T)Double.valueOf(this.cat.getNumRef().getNumCache().getPtArray(index).getV());
                }
                return (T)Double.valueOf(this.cat.getNumLit().getPtArray(index).getV());
            }
            if (this.isReference()) {
                return (T)this.cat.getStrRef().getStrCache().getPtArray(index).getV();
            }
            return (T)this.cat.getStrLit().getPtArray(index).getV();
        }
        return null;
    }

    @Override
    public boolean isReference() {
        return this.cat != null && (this.cat.isSetStrRef() || this.cat.isSetNumRef());
    }

    @Override
    public boolean isNumeric() {
        return this.cat != null && (this.cat.isSetNumRef() || this.cat.isSetNumLit());
    }

    @Override
    public String getFormulaString() {
        return this.cat != null && this.isNumeric() ? this.cat.getNumRef().getF() : this.cat.getStrRef().getF();
    }

    @Override
    public void renameSheet(String oldname, String newname) {
        if (this.isReference()) {
            if (this.isNumeric()) {
                String o = SheetNameFormatter.format(oldname);
                String n = SheetNameFormatter.format(newname);
                String ref = this.cat.getNumRef().getF();
                Pattern p = Pattern.compile(o + "!", 16);
                String newref = p.matcher(ref).replaceAll(n + "!");
                if (!newref.equals(ref)) {
                    this.cat.getNumRef().setF(newref);
                    CTNumData cache = this.cat.getNumRef().getNumCache();
                    if (cache != null) {
                        this.cat.getNumRef().unsetNumCache();
                    }
                }
            } else {
                String o = SheetNameFormatter.format(oldname);
                String n = SheetNameFormatter.format(newname);
                String ref = this.cat.getStrRef().getF();
                Pattern p = Pattern.compile(o + "!", 16);
                String newref = p.matcher(ref).replaceAll(n + "!");
                if (!newref.equals(ref)) {
                    this.cat.getStrRef().setF(newref);
                    CTStrData cache = this.cat.getStrRef().getStrCache();
                    if (cache != null) {
                        this.cat.getStrRef().unsetStrCache();
                    }
                }
            }
        }
    }
}

