/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.common;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.util.LittleEndianOutput;
import org.zkoss.poi.util.StringUtil;

public class LPWideString {
    private short cchCharacters;
    private String rgchData;

    public LPWideString(RecordInputStream in) {
        this.cchCharacters = in.readShort();
        this.rgchData = StringUtil.readUnicodeLE(in, this.cchCharacters);
    }

    public LPWideString(String str) {
        this.setString(str);
    }

    public int getCharCount() {
        return this.cchCharacters & 0xFFFF;
    }

    public String getString() {
        return this.rgchData;
    }

    public void setString(String str) {
        this.rgchData = str;
        this.cchCharacters = (short)str.length();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.cchCharacters);
        StringUtil.putUnicodeLE(this.rgchData, out);
    }

    public int getDataSize() {
        return 2 + 2 * this.cchCharacters;
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[LPWideString]").append("\n");
        sb.append(prefix).append("    .cchCharacters = ").append(Integer.toString(this.getCharCount())).append("\n");
        sb.append(prefix).append("    .rgchData      = ").append(this.getString()).append("\n");
        sb.append(prefix).append("[/LPWideString]").append("\n");
    }
}

