/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.zkoss.poi.ddf.DefaultEscherRecordFactory;
import org.zkoss.poi.ddf.EscherBoolProperty;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherDgRecord;
import org.zkoss.poi.ddf.EscherOptRecord;
import org.zkoss.poi.ddf.EscherRGBProperty;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.ddf.EscherSimpleProperty;
import org.zkoss.poi.ddf.EscherSpRecord;
import org.zkoss.poi.ddf.EscherSpgrRecord;
import org.zkoss.poi.ddf.EscherTextboxRecord;
import org.zkoss.poi.ddf.UnknownEscherRecord;
import org.zkoss.poi.hslf.record.BinaryTagDataBlob;
import org.zkoss.poi.hslf.record.CString;
import org.zkoss.poi.hslf.record.EscherTextboxWrapper;
import org.zkoss.poi.hslf.record.Record;
import org.zkoss.poi.hslf.record.RecordAtom;
import org.zkoss.poi.hslf.record.RecordTypes;
import org.zkoss.poi.hslf.record.StyleTextProp9Atom;
import org.zkoss.poi.util.LittleEndian;

public final class PPDrawing
extends RecordAtom {
    private byte[] _header = new byte[8];
    private long _type;
    private EscherRecord[] childRecords;
    private EscherTextboxWrapper[] textboxWrappers;
    private EscherDgRecord dg;

    public EscherRecord[] getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    protected PPDrawing(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        Vector<EscherRecord> escherChildren = new Vector<EscherRecord>();
        this.findEscherChildren(erf, contents, 8, len - 8, escherChildren);
        this.childRecords = escherChildren.toArray(new EscherRecord[escherChildren.size()]);
        if (1 == this.childRecords.length && -4094 == this.childRecords[0].getRecordId() && this.childRecords[0] instanceof EscherContainerRecord) {
            this.textboxWrappers = this.findInDgContainer((EscherContainerRecord)this.childRecords[0]);
        } else {
            Vector<EscherTextboxWrapper> textboxes = new Vector<EscherTextboxWrapper>();
            this.findEscherTextboxRecord(this.childRecords, textboxes);
            this.textboxWrappers = textboxes.toArray(new EscherTextboxWrapper[textboxes.size()]);
        }
    }

    private EscherTextboxWrapper[] findInDgContainer(EscherContainerRecord escherContainerF002) {
        EscherContainerRecord[] escherContainersF004;
        LinkedList<EscherTextboxWrapper> found = new LinkedList<EscherTextboxWrapper>();
        EscherContainerRecord SpgrContainer = this.findFirstEscherContainerRecordOfType((short)-4093, escherContainerF002);
        for (EscherContainerRecord spContainer : escherContainersF004 = this.findAllEscherContainerRecordOfType((short)-4092, SpgrContainer)) {
            EscherRecord escherContainerF00D;
            StyleTextProp9Atom nineAtom = this.findInSpContainer(spContainer);
            EscherSpRecord sp = null;
            EscherRecord escherContainerF00A = this.findFirstEscherRecordOfType((short)-4086, spContainer);
            if (null != escherContainerF00A && escherContainerF00A instanceof EscherSpRecord) {
                sp = (EscherSpRecord)escherContainerF00A;
            }
            if (null == (escherContainerF00D = this.findFirstEscherRecordOfType((short)-4083, spContainer)) || !(escherContainerF00D instanceof EscherTextboxRecord)) continue;
            EscherTextboxRecord tbr = (EscherTextboxRecord)escherContainerF00D;
            EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
            w.setStyleTextProp9Atom(nineAtom);
            if (null != sp) {
                w.setShapeId(sp.getShapeId());
            }
            found.add(w);
        }
        return found.toArray(new EscherTextboxWrapper[found.size()]);
    }

    private StyleTextProp9Atom findInSpContainer(EscherContainerRecord spContainer) {
        EscherContainerRecord escherContainerF011 = this.findFirstEscherContainerRecordOfType((short)-4079, spContainer);
        if (null == escherContainerF011) {
            return null;
        }
        EscherContainerRecord escherContainer1388 = this.findFirstEscherContainerRecordOfType((short)5000, escherContainerF011);
        if (null == escherContainer1388) {
            return null;
        }
        EscherContainerRecord escherContainer138A = this.findFirstEscherContainerRecordOfType((short)5002, escherContainer1388);
        if (null == escherContainer138A) {
            return null;
        }
        int size = escherContainer138A.getChildRecords().size();
        if (2 != size) {
            return null;
        }
        Record r0 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)escherContainer138A.getChild(0));
        Record r1 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)escherContainer138A.getChild(1));
        if (!(r0 instanceof CString)) {
            return null;
        }
        if (!"___PPT9".equals(((CString)r0).getText())) {
            return null;
        }
        if (!(r1 instanceof BinaryTagDataBlob)) {
            return null;
        }
        BinaryTagDataBlob blob = (BinaryTagDataBlob)r1;
        if (1 != blob.getChildRecords().length) {
            return null;
        }
        return (StyleTextProp9Atom)blob.findFirstOfType(4012L);
    }

    public PPDrawing() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, RecordTypes.PPDrawing.typeID);
        LittleEndian.putInt(this._header, 4, 0);
        this.textboxWrappers = new EscherTextboxWrapper[0];
        this.create();
    }

    private void findEscherChildren(DefaultEscherRecordFactory erf, byte[] source, int startPos, int lenToGo, Vector<EscherRecord> found) {
        int escherBytes = LittleEndian.getInt(source, startPos + 4) + 8;
        EscherRecord r = erf.createRecord(source, startPos);
        r.fillFields(source, startPos, erf);
        found.add(r);
        int size = r.getRecordSize();
        if (size < 8) {
            logger.log(5, "Hit short DDF record at " + startPos + " - " + size);
        }
        if (size != escherBytes) {
            logger.log(5, "Record length=" + escherBytes + " but getRecordSize() returned " + r.getRecordSize() + "; record: " + r.getClass());
            size = escherBytes;
        }
        startPos += size;
        if ((lenToGo -= size) >= 8) {
            this.findEscherChildren(erf, source, startPos, lenToGo, found);
        }
    }

    private void findEscherTextboxRecord(EscherRecord[] toSearch, Vector<EscherTextboxWrapper> found) {
        block0: for (int i = 0; i < toSearch.length; ++i) {
            if (toSearch[i] instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)toSearch[i];
                EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
                found.add(w);
                for (int j = i; j >= 0; --j) {
                    if (!(toSearch[j] instanceof EscherSpRecord)) continue;
                    EscherSpRecord sp = (EscherSpRecord)toSearch[j];
                    w.setShapeId(sp.getShapeId());
                    continue block0;
                }
                continue;
            }
            if (!toSearch[i].isContainerRecord()) continue;
            List<EscherRecord> childrenL = toSearch[i].getChildRecords();
            EscherRecord[] children = new EscherRecord[childrenL.size()];
            childrenL.toArray(children);
            this.findEscherTextboxRecord(children, found);
        }
    }

    @Override
    public long getRecordType() {
        return this._type;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        for (int i = 0; i < this.textboxWrappers.length; ++i) {
            this.textboxWrappers[i].writeOut(null);
        }
        int newSize = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            newSize += this.childRecords[i].getRecordSize();
        }
        LittleEndian.putInt(this._header, 4, newSize);
        out.write(this._header);
        byte[] b = new byte[newSize];
        int done = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            int written = this.childRecords[i].serialize(done, b);
            done += written;
        }
        out.write(b);
    }

    private void create() {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        EscherDgRecord dg = new EscherDgRecord();
        dg.setOptions((short)16);
        dg.setNumShapes(1);
        dgContainer.addChildRecord(dg);
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        spgrContainer.setOptions((short)15);
        spgrContainer.setRecordId((short)-4093);
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        spgr.setOptions((short)1);
        spContainer.addChildRecord(spgr);
        EscherSpRecord sp = new EscherSpRecord();
        sp.setOptions((short)2);
        sp.setFlags(5);
        spContainer.addChildRecord(sp);
        spgrContainer.addChildRecord(spContainer);
        dgContainer.addChildRecord(spgrContainer);
        spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        sp = new EscherSpRecord();
        sp.setOptions((short)18);
        sp.setFlags(3072);
        spContainer.addChildRecord(sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherRGBProperty(385, 0x8000000));
        opt.addEscherProperty(new EscherRGBProperty(387, 0x8000005));
        opt.addEscherProperty(new EscherSimpleProperty(403, 10064750));
        opt.addEscherProperty(new EscherSimpleProperty(404, 7778750));
        opt.addEscherProperty(new EscherBoolProperty(447, 0x120012));
        opt.addEscherProperty(new EscherBoolProperty(511, 524288));
        opt.addEscherProperty(new EscherSimpleProperty(772, 9));
        opt.addEscherProperty(new EscherSimpleProperty(831, 65537));
        spContainer.addChildRecord(opt);
        dgContainer.addChildRecord(spContainer);
        this.childRecords = new EscherRecord[]{dgContainer};
    }

    public void addTextboxWrapper(EscherTextboxWrapper txtbox) {
        EscherTextboxWrapper[] tw = new EscherTextboxWrapper[this.textboxWrappers.length + 1];
        System.arraycopy(this.textboxWrappers, 0, tw, 0, this.textboxWrappers.length);
        tw[this.textboxWrappers.length] = txtbox;
        this.textboxWrappers = tw;
    }

    public EscherDgRecord getEscherDgRecord() {
        if (this.dg == null) {
            EscherContainerRecord dgContainer = (EscherContainerRecord)this.childRecords[0];
            Iterator<EscherRecord> it = dgContainer.getChildIterator();
            while (it.hasNext()) {
                EscherRecord r = it.next();
                if (!(r instanceof EscherDgRecord)) continue;
                this.dg = (EscherDgRecord)r;
                break;
            }
        }
        return this.dg;
    }

    protected EscherContainerRecord findFirstEscherContainerRecordOfType(short type, EscherContainerRecord parent) {
        if (null == parent) {
            return null;
        }
        List<EscherContainerRecord> children = parent.getChildContainers();
        for (EscherContainerRecord child : children) {
            if (type != child.getRecordId()) continue;
            return child;
        }
        return null;
    }

    protected EscherRecord findFirstEscherRecordOfType(short type, EscherContainerRecord parent) {
        if (null == parent) {
            return null;
        }
        List<EscherRecord> children = parent.getChildRecords();
        for (EscherRecord child : children) {
            if (type != child.getRecordId()) continue;
            return child;
        }
        return null;
    }

    protected EscherContainerRecord[] findAllEscherContainerRecordOfType(short type, EscherContainerRecord parent) {
        if (null == parent) {
            return new EscherContainerRecord[0];
        }
        List<EscherContainerRecord> children = parent.getChildContainers();
        LinkedList<EscherContainerRecord> result = new LinkedList<EscherContainerRecord>();
        for (EscherContainerRecord child : children) {
            if (type != child.getRecordId()) continue;
            result.add(child);
        }
        return result.toArray(new EscherContainerRecord[result.size()]);
    }

    protected Record buildFromUnknownEscherRecord(UnknownEscherRecord unknown) {
        byte[] bingo = unknown.getData();
        byte[] restoredRecord = new byte[8 + bingo.length];
        System.arraycopy(bingo, 0, restoredRecord, 8, bingo.length);
        short recordVersion = unknown.getVersion();
        short recordId = unknown.getRecordId();
        int recordLength = unknown.getRecordSize();
        LittleEndian.putShort(restoredRecord, 0, recordVersion);
        LittleEndian.putShort(restoredRecord, 2, recordId);
        LittleEndian.putInt(restoredRecord, 4, recordLength);
        return Record.createRecordForType(recordId, restoredRecord, 0, restoredRecord.length);
    }

    public StyleTextProp9Atom[] getNumberedListInfo() {
        EscherRecord[] escherRecords;
        LinkedList<StyleTextProp9Atom> result = new LinkedList<StyleTextProp9Atom>();
        for (EscherRecord escherRecord : escherRecords = this.getEscherRecords()) {
            EscherContainerRecord[] escherContainersF004;
            if (!(escherRecord instanceof EscherContainerRecord) || -4094 != escherRecord.getRecordId()) continue;
            EscherContainerRecord escherContainerF002 = (EscherContainerRecord)escherRecord;
            EscherContainerRecord escherContainerF003 = this.findFirstEscherContainerRecordOfType((short)-4093, escherContainerF002);
            for (EscherContainerRecord containerF004 : escherContainersF004 = this.findAllEscherContainerRecordOfType((short)-4092, escherContainerF003)) {
                BinaryTagDataBlob blob;
                int size;
                EscherContainerRecord escherContainer138A;
                EscherContainerRecord escherContainer1388;
                EscherContainerRecord escherContainerF011 = this.findFirstEscherContainerRecordOfType((short)-4079, containerF004);
                if (null == escherContainerF011 || null == (escherContainer1388 = this.findFirstEscherContainerRecordOfType((short)5000, escherContainerF011)) || null == (escherContainer138A = this.findFirstEscherContainerRecordOfType((short)5002, escherContainer1388)) || 2 != (size = escherContainer138A.getChildRecords().size())) continue;
                Record r0 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)escherContainer138A.getChild(0));
                Record r1 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)escherContainer138A.getChild(1));
                if (!(r0 instanceof CString) || !"___PPT9".equals(((CString)r0).getText()) || !(r1 instanceof BinaryTagDataBlob) || 1 != (blob = (BinaryTagDataBlob)r1).getChildRecords().length) continue;
                result.add((StyleTextProp9Atom)blob.findFirstOfType(4012L));
            }
        }
        return result.toArray(new StyleTextProp9Atom[result.size()]);
    }
}

