
(function () {
var WRAP_TEXT_CLASS = 'zscelltxt-wrap';
var NUM_CELL = 0,
	STR_CELL = 1,
	FORMULA_CELL = 2,
	BLANK_CELL = 3,
	BOOLEAN_CELL = 4,
	ERROR_CELL = 5,
	Cell = 
zss.Cell = zk.$extends(zk.Widget, {
	widgetName: 'Cell',
	
	
	
	
	
	ref: null,
	
	src: null,
	
	text: '',
	
	lock: true,
	
	overflow: false,
	
	cellType: 3,
	
	halign: "l",
	
	valign: 'b',
	
	wrap: false,
	
	fontSize: 11,
	
	fontFormat: 0,
	
	comment: null,
	
	
	
	
	$init: function (sheet, block, row, col, src) {
		this.$supers(zss.Cell, '$init', []);
		
		this.sheet = sheet; 
		this.block = block; 
		this.r = row;
		this.c = col;
		this.src = src;
		
		var	cellData = src.getRow(row).getCell(col),
			colHeader = src.columnHeaders[col],
			rowHeader = src.rowHeaders[row];
		this.text = cellData.text || '';
		this.indention = cellData.indention;
		if (colHeader && rowHeader) {
			this.ref = colHeader.t + rowHeader.t;
		}
		this.edit = cellData.editText ? cellData.editText : '';
		this.hastxt = !!this.text;
		this.zsw = src.getColumnWidthId(col);
		this.zsh = src.getRowHeightId(row);
		this.lock = cellData.lock;
		this.cellType = cellData.cellType;
		
		this.halign = cellData.halign;
		this.valign = cellData.valign;
		this.rborder = cellData.rightBorder;
		if (cellData.fontSize){
			this.fontSize = cellData.fontSize;
		}

		var mId = cellData.mergeId;
		if (mId) {
			var r = cellData.merge;
			this.merid = mId;
			this.merl = r.left;
			this.merr = r.right;
			this.mert = r.top;
			this.merb = r.bottom;
			this.mergeCls = cellData.mergeCls;
		}
		this.wrap = cellData.wrap;
		this.overflow = cellData.overflow;
		
		
		this.overflowOpt = cellData.overflowOpt;  
		
		this.style = cellData.style;
		this.innerStyle = cellData.innerStyle;
		this.fontStyle = cellData.fontStyle;
		
		
		this.comment = cellData.comment;
		
		
		if (cellData.db_tlbr)
			this.db_tlbr = cellData.db_tlbr;
		else
			delete this.db_tlbr;

		
		if (cellData.af_tlbr)
			this.af_tlbr = cellData.af_tlbr;
		else
			delete this.af_tlbr;
		
		
		if (cellData.dbar)
			this.dbar = cellData.dbar;
		else
			delete this.dbar;
		
		
		this.rotate = cellData.rotate;
		
		
		this._cah = cellData._cah;
		delete cellData._cah;
		
		
		this._txtwd = cellData._txtwd;
	},
	
	_updateCacheSrc: function (src) {
		this.src = src;
	},
	getVerticalAlign: function () {
		switch (this.valign) {
		case 'b':
			return 'verticalAlignBottom';
		case 'c':
			return 'verticalAlignMiddle';
		case 't':
			return 'verticalAlignTop';
		}
	},
	getHorizontalAlign: function () {
		switch (this.halign) {
		case 'l':
			return 'horizontalAlignLeft';
		case 'c':
			return 'horizontalAlignCenter';
		case 'r':
			return 'horizontalAlignRight';
		}
	},
	getFontName: function () {
		var fn = jq(this.getTextNode()).css('font-family');
		if(fn){
			fn = fn.replace(/'/g,"");
		}
		return fn;
	},
	
	getFontSize: function () {
		return this.fontSize;
	},
	isFontBold: function () {
		


		return (this.fontFormat & 0x01) != 0;
	},
	isFontItalic: function () {
		

		return (this.fontFormat & 0x02) != 0;
	},
	isFontUnderline: function () {
		



		return (this.fontFormat & 0x04) != 0;
	},
	isFontStrikeout: function () {
		



		return (this.fontFormat & 0x08) != 0;
	},
	doClick_: function (evt) {
		
	},
	doRightClick_: function (evt) {
		this.sheet._doMouserightclick(evt);
	},
	doMouseDown_: function (evt) {
		this.sheet._doMousedown(evt);
	},
	doMouseUp_: function (evt) {
		this.sheet._doMouseup(evt);
	},
	doDoubleClick_: function (evt) {
		this.sheet._doMousedblclick(evt);
	},
	
	isSelectable: function () {
		var wgt = this.sheet._wgt;
		return !wgt.isProtect() || wgt.allowSelectLockedCells || 
			(wgt.allowSelectUnlockedCells && !this.isLocked());
	},
	
	isLocked: function () {
		return this.lock;
	},























































	
	update_: function (updateSrc) {
		if (updateSrc) { 
			var cctl = this.sheet._wgt._cacheCtrl,
				csrc = cctl ? cctl.getSelectedSheet() : null;
			if (csrc) {
				this._updateCacheSrc(csrc);
			}
		}
		var r = this.r,
			c = this.c,
			data = this.src.getRow(r).getCell(c),
			format = data.formatText,
			st = this.style = data.style,
			ist = this.innerStyle = data.innerStyle,
			fontStyleChg = this.fontStyle != data.fontStyle,
			fst = this.fontStyle = data.fontStyle,
			n = this.comp,
			overflow = data.overflow,
			cellTypeAfter = data.cellType, 
			txt = data.text,
			txtChd = txt != this.text,
			indention = data.indention,
			indentionChd = indention != this.indention,
			cave = this.$n('cave'),
			prevWidth = cave.style.width,
			fontSize = data.fontSize,
			fontFormat = data.fontFormat, 
			real = this.$n('real');

		
		var wasRotate90 = this.rotate == 90 || this.rotate == -90, 
			toRotate90 = data.rotate == 90 || data.rotate == -90, 
			
			wrap0 = !toRotate90 && data.wrap,
			wrapChanged = this.wrap != wrap0,
			valignChanged = this.valign != data.valign,
			halignChanged = this.halign != data.halign,
			rotateChanged = this.rotate != data.rotate;
		
		var fontSizeChanged = false;
		if (fontSize != undefined) {
			fontSizeChanged = this.fontSize != data.fontSize
			this.fontSize = fontSize;
		}
		
		if (fontFormat != undefined) {
			this.fontFormat = fontFormat;
		}
		this.$n().style.cssText = st;
		cave.style.cssText = ist;
		


		
		
		var orgwidth = real && real.style ? real.style.width : null,
			orgTransOrigin = real && real.style ? real.style.transformOrigin : null, 
			orgTrans = real && real.style ?  real.style[zk.ie && zk.ie < 10 ? '-ms-transform' : 'transform'] : null, 
			orgFamily = real && real.style ? real.style.fontFamily : null;
		
		real.style.cssText = fst;
		if (orgwidth && !indentionChd && !real.style.width) {
			jq(real).css('width', orgwidth);
		}

		
		
		var overflowChd = txtChd || fontSizeChanged || orgFamily != real.style.fontFamily || indentionChd; 
		if (overflowChd) delete this._txtwd;  

		
		if (toRotate90) {
			if (orgTransOrigin && !real.style.transformOrigin) {
				real.style['transform-origin'] = orgTransOrigin;
			}
			
			if (orgTrans && !real.style[zk.ie && zk.ie < 10 ? '-ms-transform' : 'transform']) {
				real.style[zk.ie && zk.ie < 10 ? '-ms-transform' : 'transform'] = orgTrans;
				
				cave.style['text-align'] = ''; 
			}
		}
		
		this.lock = data.lock;
		this.wrap = data.wrap;
		this.halign = data.halign;
		this.valign = data.valign;
		this.rborder = data.rightBorder;
		this.edit = data.editText;
		this.indention = data.indention;
		
		this._updateListenOverflow(overflow);
		this.setText(txt, false, wrapChanged); 
		
		
		
		var link = jq(real).children('a')[0];
		if (link && fontStyleChg) {
			link.style.cssText = fst;
		}

		if (wrapChanged) {
			if (wrap0) {
				jq(this.getTextNode()).addClass(WRAP_TEXT_CLASS);
			} else {
				jq(this.getTextNode()).removeClass(WRAP_TEXT_CLASS);
			}
		}
		
		
		if (this.db_tlbr != data.db_tlbr) {
			if (this.db_tlbr) {
				jq(this.comp).removeClass(this.db_tlbr);
			}
			if (data.db_tlbr) {
				jq(this.comp).addClass(this.db_tlbr=data.db_tlbr);
			} else {
				delete this.db_tlbr;
			}
		}
		
		
		if (this.af_tlbr != data.af_tlbr) {
			if (this.af_tlbr) {
				jq(this.comp).removeClass(this.af_tlbr);
			}
			if (data.af_tlbr) {
				jq(this.comp).addClass(this.af_tlbr=data.af_tlbr);
			} else {
				delete this.af_tlbr;
			}
		}
		
		if (this.overflow != overflow 
			|| (this.overflow && overflowChd)) { 
			var processedOverflow = false;
			if (this.overflow && !overflow) {
				this._clearOverflow();
				processedOverflow = true;
			}
			this.overflow = overflow;
			if (!processedOverflow)
				this._processOverflow();	
		}
		
		
		if (this.cellType != cellTypeAfter
			&& (this.cellType == BLANK_CELL || cellTypeAfter == BLANK_CELL)) {
			this.sheet.triggerOverflowColumn_(this.r, this.c);
		}
		this.cellType = cellTypeAfter;

		var processWrap = wrapChanged || (wrap0 && (txtChd || fontSizeChanged));
		if (this._justCopied === true){	
			processWrap = false;
			delete this._justCopied;
		}
		
		
		this._updateListenRotate(toRotate90);
		if (rotateChanged || valignChanged || halignChanged || fontSizeChanged || this.redoRotate
			|| (wasRotate90 && txtChd)) { 
			var processedRotate = false;
			if (wasRotate90 && !toRotate90) {
				this._clearRotate();
				processedRotate = true;
			}
			this.rotate = data.rotate;
			if (!processedRotate)
				this._processRotate();
			delete this.redoRotate; 
		}

		
		if (
			txtChd ||
			fontStyleChg ||
			fontSizeChanged || 
			rotateChanged || 
			indentionChd ||
			((this.cellType == STR_CELL || this.cellType == BLANK_CELL) && !this.merid && processWrap) 
		) { 
			this._updateCellAutoHeight(r, c);
		}
	},
	
	_updateCellAutoHeight: function () {
		
		if (this.sheet._wgt._ignoreAutoHeight) return;
		
		var newHeight = this._getTextHeight0();
		this.parent.updateAutoHeightDirty(this._txtHgh || -1, newHeight);
		this._txtHgh = newHeight;
		this.parent.processCellAutoHeight(this);
		
		
		this.sheet._sendOnTextHeight(this.r, this.c, newHeight);
	},
	
	
	_updateListenRotate: function (b) {
		var curr = !!this._listenProcessRotate;
		if (curr != b) {
			this.sheet[curr ? 'unlisten' : 'listen']({onProcessRotate: this.proxy(this._onProcessRotate)});
			this._listenProcessRotate = b;
			return true;
		}
		return false;
	},
	
	_clearRotate: function () {
		var real = this.$n('real')
			$real = jq(real);
		
		$real.css(zk.ie && zk.ie < 10 ? '-ms-transform' : 'transform', ''); 
		$real.css('transform-origin', ''); 
	},
	
	_processRotate: function () {
		
	},
	
	_updateListenOverflow: function (b) {
		var curr = !!this._listenProcessOverflow;
		if (curr != b) {
			this.sheet[curr ? 'unlisten' : 'listen']({onProcessOverflow: this.proxy(this._onProcessOverflow)});
			this._listenProcessOverflow = b;
			return true;
		}
		return false;
	},
	_updateHasTxt: function (bool) {
		this.hastxt = bool;
		
		var zIdx = this.getZIndex();
		jq(this.comp).css('z-index', bool ? "" : zIdx);
	},
	
	setText: function (txt) {
		if (!txt)
			txt = "";
		var oldTxt = this.getText(),
			difTxt = txt != oldTxt;
		this._updateHasTxt(txt != "");
		this._setText(txt);
	},
	
	getTextHeight: function () {		
		var h = this._txtHgh;
		return h != undefined ? h : this._txtHgh = this._getTextHeight0();
	},
	_getTextHeight0: function () {
		return jq(this.getTextNode()).height();
	},
	_updateVerticalAlign: zk.ie6_ || zk.ie7_ ? function () {
		var	v = this.valign,
			text = this.text,
			cv = this.$n('cave');
		if (cv.style.display == 'none' || !text)
			return;
		var	$n = jq(cv),
			$t = jq(this.getTextNode());
		
		switch (v) {
		case 't':
			$t.css({'top': "0px", 'bottom': ''});
			break;
		case 'c':
			var ch = $n.height(),
				ich = $t.height();
			if (!ch || !ich)
				return;
			var	ah = (ch - ich) / 2,
				p = Math.ceil(ah * 100 / ch);
			if (p)
				$t.css({'top': p + "%", 'bottom': ''});
			break;
		case 'b':
			$t.css({'bottom': "0px", 'top': ''});	
			break;
		}
	} : zk.$void(),
	_onRowHeightChanged: function (evt) {
		if (evt.data.row == this.r)
			this._updateVerticalAlign();
	},
	_updateListenRowHeightChanged: function (b) {
		var curr = !!this._listenRowHeightChanged;
		if (curr != b) {
			this.sheet[curr ? 'unlisten' : 'listen']({onRowHeightChanged: this.proxy(this._onRowHeightChanged)});
			this._listenRowHeightChanged = b;
		}
	},
	getText: function () {
		return this.getTextNode().innerHTML;
	},
	getPureText: function () { 
		var n = this.getTextNode();
		return n.textContent || n.innerText;
	},
	_setText: function (txt) {
		if (!txt)
			txt = "";
		this.text = this.getTextNode().innerHTML = txt;
		
		if (zk.ie6_ || zk.ie7_) {
			if (txt) {
				this._updateVerticalAlign();
			}
			this._updateListenRowHeightChanged(!!txt);
		}
	},
	redraw: function (out) {
		out.push(this.getHtml());
	},
	getHtml: function () {
		var	uid = this.uuid,
			text = this.text,
			style = this.domStyle_(),
			innerStyle = this.innerStyle,
			fontStyle = this.fontStyle;
		
		return '<div id="' + uid + '" class="' + this.getZclass() + '" zs.t="SCell" '
			+ (style ? 'style="' +  style + '"' : '') + '><div id="' + uid + '-cave" class="' +
			this._getInnerClass() + '" ' + (innerStyle ? 'style="' + innerStyle + '"' : '') + 
			'>' + this.getCommentHtml(this.comment) 
			+ '<div id="' + uid + '-real" class="' + this._getRealClass() + '"' +
			
			(fontStyle ? ' style="' + fontStyle + '"' : '') + '>' + text + '</div>' + '</div></div>';
	},
	getCommentHtml: function(shown) {
		
		return '';
	},
	getZIndex: function () {
		if (zk.ie6_ || zk.ie7_)
			return this.cellType == BLANK_CELL ? -1 : 1;
		return this.text ? null : 1;
	},
	domStyle_: function () {
		var st = this.style;
		if (st) {
			return st;
		} else {
			var zIdx = this.getZIndex();
			if (zIdx){
				return 'z-index:' + zIdx + ';';
			}
		}
	},
	getTextNode: function () {
		return this.$n('real');
	},
	_clearOverflow: function () {
		jq(this.getTextNode()).css('width', '');
		jq(this.$n()).removeClass("zscell-overflow").removeClass("zscell-overflow-b");
	},
	_processOverflow: function () {
		
	},
	
	_setTempMergeCellStyle: function (l, t, r, b, cutw, cuth, ml, mt, mr, mb) {
		var comp = this.comp, 
			jqcomp = comp ? jq(comp) : null;
			
		if (jqcomp) {

			if (cutw) { 
				var width = this.sheet.custColWidth.getDiffPixel(l, r); 
				var mwidth = l != ml || r != mr ?
						this.sheet.custColWidth.getDiffPixel(ml, mr) - 4 : width; 
				if (width != mwidth) { 
					var jqreal = jq(this.getTextNode());
					jqreal.attr("mergewidth", true);
				}
			}
			if (cuth) {
				var height = this.sheet.custRowHeight.getDiffPixel(t, b);
				jqcomp.css("height", height);
			}
			if (jqcomp.hasClass("zsmergee")) {
				jqcomp.removeClass("zsmergee");
				jqcomp.attr("zsmergeex", true);
			} else if (jqcomp.hasClass("zsmergeeu")) {
				jqcomp.css("visibility", "visible");
			}
		}
	},
	
	_resetTempMergeCellStyle: function () {
		var comp = this.comp,
			jqcomp = comp ? jq(comp) : null;
		if (jqcomp) {
			jqcomp.css("width", "");
			jqcomp.css("height", "");
			
			var jqreal = jq(this.getTextNode()),
				mergewidth = jqreal ? jqreal.attr("mergewidth") : null;
		
			if (mergewidth) {
				jqreal.css("width", "");
				jqreal.removeAttr("mergewidth");
			}
			if (jqcomp.attr("zsmergeex")) {
				jqcomp.removeAttr("zsmergeex");
				jqcomp.addClass("zsmergee");
			} else if (jqcomp.hasClass("zsmergeeu")) {
				jqcomp.css("visibility", "");
			}
		}
	},
	bind_: function (desktop, skipper, after) {
		
		var tmp = this.block._newrange,
		    finalNewrange = this.block._finalNewrange;
		try {
			if(finalNewrange) {
				this.block._newrange = finalNewrange;
			}
			this.bind0_(desktop, skipper, after);
		} finally {
			if(finalNewrange) {
				this.block._newrange = tmp;
			}
		}
	},
	bind0_: function (desktop, skipper, after) {
		this.$supers(zss.Cell, 'bind_', arguments);
		
		var n = this.comp = this.$n(),
			sheet = this.sheet;
		n.ctrl = this;
		this.cave = n.firstChild;

		
		if (this.merid) {
			var range = this.block._newrange,
				rr = range.right,
				rl = range.left,
				rt = range.top,
				rb = range.bottom,
				ml = this.merl,
				mr = this.merr,
				mt = this.mert,
				mb = this.merb,
				xl = Math.max(rl, ml),
				xt = Math.max(rt, mt),
				xr = Math.min(rr, mr),
				xb = Math.min(rb, mb),
				candidate = (xl == this.c && xt == this.r)  	
							|| (xr == this.c && xb == this.r); 	
			if (candidate) {
				var cutw = xr < mr || xl > ml,
					cuth = xb < mb || xt > mt;
				this.block._addTempMerge(ml, mt, mr, mb, xl, xt, xr, xb, cutw, cuth);
			}
		}

		if (this.cellType == BLANK_CELL) {
			return;
		}
		this._updateListenOverflow(this.overflow);
		
		if (!!this.text && (zk.ie6_ || zk.ie7_) && this.valign != 't') { 
			this._updateListenRowHeightChanged(true);
			this._updateVerticalAlign();
		}

        
        if (this.cellType == STR_CELL || this.cellType == FORMULA_CELL){
            
            if (this.sheet._wgt.isSheetCSSReady()) {
                this.processAlignmentOverflow();
            }else{ 
                this.sheet.addSSInitLater(this.processAlignmentOverflow.bind(this));
            }
        }

		
		var toRotate90 = this.rotate == 90 || this.rotate == -90; 
		this._updateListenRotate(toRotate90);
		if (toRotate90) {
			this._processRotate(); 
			return; 
		}

		
		this._saveNoneDefaultHeightCell();
		
		
		if (this._cah) {
			this._updateCellAutoHeight();
			delete this._cah;
			this.sheet._cah = true; 
		}
	},
	_saveNoneDefaultHeightCell: function () {
		
	},
	unbind_: function () {
		this._updateListenOverflow(false);
		this._updateListenRotate(false); 
		this._updateListenRowHeightChanged(false);
		this.parent.removeAutoHeightCell(this);
		
		this.comp = this.comp.ctrl = this.cave = this.sheet = this.overlapBy = this._listenRowHeightChanged =
		this.block = this.lock = null;
		
		this.$supers(zss.Cell, 'unbind_', arguments);
	},
    
    shiftAlignedText: function() {
        if (!(this.overflow || this.isMerged())){ 
            return;
        }
        var ALIGNMENT_SHIFT = "zscell-alignment-shifted"; 
		var $textNode = jq(this.getTextNode());
		if (this.halign == 'l'){ 
            $textNode.removeClass(ALIGNMENT_SHIFT);
        }else{
            this.computeTextWidth();
			var cellInnerWidth = jq(this.$n()).width(); 
			if (this._txtwd > cellInnerWidth){
				$textNode.addClass(ALIGNMENT_SHIFT);
				
                if (this.halign == 'r'){
				    $textNode.css('left', jq.px(cellInnerWidth - this._txtwd));
                }else if (this.halign == 'c'){
				    $textNode.css('left', jq.px(Math.round((cellInnerWidth - this._txtwd)/2)));
			    }
            }
        }
    },
    
    computeTextWidth: function(){
        var noTextWidth = (this._txtwd == undefined || this._txtwd < 0);  
        var currentWidth = noTextWidth ? this.getTextNode().scrollWidth : this._txtwd;
        var textWidth = zk.ie9_ ? currentWidth : jq(this.$n('cave')).width();
        this._txtwd = textWidth;
        return textWidth;
    },
	
	
	_onProcessRotate: function (evt) {
		data = evt.data;
		if (data) {
			var row = this.r,
				tRow = data.tRow,
				bRow = data.bRow;
			if (this.c == data.col
				&& ((tRow == undefined && bRow == undefined) || 
						(tRow && bRow && row >= tRow && row <= bRow))) {
				var rotate90 = this.rotate == 90 || this.rotate == -90; 
				if (rotate90)
					this._processRotate();
			}
		}
	},
	
	_onProcessOverflow: function (evt) {
		if (this.overflow) {
			var row = this.r,
				data = evt.data;
			if (data) {
				var rCol = data.col,
					tRow = data.tRow,
					bRow = data.bRow;
				if (this.c < data.col) {
					if ((tRow == undefined && bRow == undefined) || 
						(tRow && bRow && row >= tRow && row <= bRow)) {
						this._processOverflow(true);
					}
				}
			}
		}
	},
	processAlignmentOverflow: function(){
        
        
        var skipOverflowOnBinding = (this.overflowOpt & 2) != 0; 
        if (this.overflow && !skipOverflowOnBinding) {
            this._processOverflow(); 
        }
        
        
        this.shiftAlignedText();
	},
	
	getZclass: function () {
		var cls = 'zscell',
			hId = this.zsh,
			wId = this.zsw,
			mCls = this.mergeCls,
			db_tlbr = this.db_tlbr, 
			af_tlbr = this.af_tlbr; 
		if (hId)
			cls += (' zshi' + hId);
		if (wId)
			cls += (' zsw' + wId);
		if (mCls)
			cls += (' ' + mCls);
		if (db_tlbr)
			cls += (' ' + db_tlbr);
		if (af_tlbr)
			cls += (' ' + af_tlbr);
		return cls;
	},
	_getInnerClass: function () {
		var cls = 'zscelltxt',
			hId = this.zsh,
			wId = this.zsw;
		if (hId)
			cls += (' zshi' + hId);
		if (wId)
			cls += (' zswi' + wId);
		
		
		



		return cls;
	},
	_getRealClass: function() {
		
		var rotate90 = this.rotate == 90 || this.rotate == -90, 
			cls = 'zscelltxt-real ' + (this.wrap && !rotate90 ? WRAP_TEXT_CLASS:''),
			hId = this.zsh;

		if(hId) 
			cls += (' zshr' + hId);

		return cls;
	},
	
	appendZSW: function (zsw) {
		if (zsw) {
			this.zsw = zsw;
			jq(this.comp).addClass("zsw" + zsw);
			jq(this.cave).addClass("zswi" + zsw);
		}
	},
	
	appendZSH: function (zsh) {
		if (zsh) {
			this.zsh = zsh;
			jq(this.comp).addClass("zshi" + zsh);
			jq(this.cave).addClass("zshi" + zsh);
			jq(this.$n('real')).addClass("zshr" + zsh);
		}
	},
	
	resetColumnIndex: function (newcol) {
		var	src = this.src;
		this.ref = src.columnHeaders[newcol].t + src.rowHeaders[this.r].t;
		this.c = newcol;
	},
	
	resetRowIndex: function (newrow) {
		var	src = this.src;
		this.ref = src.columnHeaders[this.c].t + src.rowHeaders[newrow].t;
		this.r = newrow;
	},
	
	isInRange: function (row, col) {
		return this.merid ? this.mert <= row && this.merb >= row && this.merl <= col && this.merr >= col:
			this.r == row && this.c == col;
	},
	
	isMerged: function(){
	    return this.merid != null;
	},
	
	isMergedAcrossFrozenColumn: function(){
        return this.isMerged()
        && this.merl <= this.sheet.frozenCol
        && this.merr > this.sheet.frozenCol;
	}
});
})();