/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;
import org.zkoss.lang.Objects;
import org.zkoss.util.resource.Labels;

public class InsertCellAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = 2494062898483762218L;
    Range.InsertShift _shift;
    Range.InsertCopyOrigin _copyOrigin;
    boolean _doFlag;

    public InsertCellAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Range.InsertShift shift, Range.InsertCopyOrigin copyOrigin) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._shift = shift;
        this._copyOrigin = copyOrigin;
    }

    @Override
    public void doAction() {
        if (this.isSheetProtected()) {
            return;
        }
        this._doFlag = true;
        Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        CellOperationUtil.insert(r, this._shift, this._copyOrigin);
    }

    @Override
    public boolean isUndoable() {
        return this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public boolean isRedoable() {
        return !this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public void undoAction() {
        if (this.isSheetProtected()) {
            return;
        }
        Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        switch (this._shift) {
            case DOWN: {
                CellOperationUtil.delete(r, Range.DeleteShift.UP);
                break;
            }
            case RIGHT: {
                CellOperationUtil.delete(r, Range.DeleteShift.LEFT);
                break;
            }
            case DEFAULT: {
                CellOperationUtil.delete(r, Range.DeleteShift.DEFAULT);
            }
        }
        this._doFlag = false;
    }

    @Override
    protected boolean isSheetProtected() {
        Range range = Ranges.range(this._sheet);
        return !(!super.isSheetProtected() || Objects.equals((Object)Labels.getLabel((String)"zss.undo.insertColumn"), (Object)this.getLabel()) && range.getSheetProtection().isInsertColumnsAllowed() || Objects.equals((Object)Labels.getLabel((String)"zss.undo.insertRow"), (Object)this.getLabel()) && range.getSheetProtection().isInsertRowsAllowed());
    }
}

