/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.SheetProtection;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.HideHeaderAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class HideHeaderHandler
extends AbstractHandler {
    private static final long serialVersionUID = 9120677511231533029L;
    final HideHeaderAction.Type _type;
    final boolean _hide;

    public HideHeaderHandler(HideHeaderAction.Type type, boolean hide) {
        this._type = type;
        this._hide = hide;
    }

    @Override
    protected boolean processAction(UserActionContext ctx) {
        AreaRef selection;
        Sheet sheet = ctx.getSheet();
        Range range = Ranges.range(sheet, selection = ctx.getSelection());
        if (range.isProtected()) {
            switch (this._type) {
                case COLUMN: {
                    if (range.getSheetProtection().isFormatColumnsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
                case ROW: {
                    if (range.getSheetProtection().isFormatRowsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
            }
        }
        if (this._hide && this._type == HideHeaderAction.Type.ROW && this.checkSelectAllVisibleRow(ctx)) {
            throw new IllegalOpArgumentException(Labels.getLabel((String)"zss.msg.operation_not_supported_with_all_row"));
        }
        if (this._hide && this._type == HideHeaderAction.Type.COLUMN && this.checkSelectAllVisibleColumn(ctx)) {
            throw new IllegalOpArgumentException(Labels.getLabel((String)"zss.msg.operation_not_supported_with_all_column"));
        }
        String label = null;
        switch (this._type) {
            case COLUMN: {
                label = this._hide ? Labels.getLabel((String)"zss.undo.hideColumn") : Labels.getLabel((String)"zss.undo.unhideColumn");
                break;
            }
            case ROW: {
                label = this._hide ? Labels.getLabel((String)"zss.undo.hideRow") : Labels.getLabel((String)"zss.undo.unhideRow");
            }
        }
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new HideHeaderAction(label, sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), this._type, this._hide));
        return true;
    }

    @Override
    public boolean isEnabled(Book book, Sheet sheet) {
        if (book == null || sheet == null) {
            return false;
        }
        if (!sheet.isProtected()) {
            return true;
        }
        SheetProtection sheetProtection = Ranges.range(sheet).getSheetProtection();
        boolean allowed = false;
        switch (this._type) {
            case COLUMN: {
                allowed = sheetProtection.isFormatColumnsAllowed();
                break;
            }
            case ROW: {
                allowed = sheetProtection.isFormatRowsAllowed();
            }
        }
        return allowed;
    }
}

