/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.CellEvent;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class CellFocusedCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)CellFocusedCommand.class.getCanonicalName());
        }
        Map data = request.getData();
        if (data == null || data.size() != 3) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), CellFocusedCommand.class.getCanonicalName()});
        }
        String sheetId = (String)data.get("sheetId");
        int row = (Integer)data.get("row");
        int col = (Integer)data.get("col");
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        if (!CellFocusedCommand.getSheetUuid(sheet).equals(sheetId)) {
            return;
        }
        SpreadsheetInCtrl ctrl = (SpreadsheetInCtrl)((Spreadsheet)comp).getExtraCtrl();
        ctrl.setFocusRect(col, row, col, row);
        Events.postEvent((Event)new CellEvent("onCellFocus", comp, sheet, row, col, null));
    }
}

