/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.theme;

import io.keikai.theme.SpreadsheetStandardTheme;
import io.keikai.theme.SpreadsheetThemeRegistry;
import io.keikai.theme.SpreadsheetThemeResolver;
import java.util.Comparator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.zkoss.lang.Library;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.web.theme.Theme;

public class SpreadsheetThemeFns {
    private static final String SPREADSHEET_THEME_PREFERRED_KEY = "io.keikai.theme.preferred";
    private static SpreadsheetThemeRegistry _themeRegistry = null;
    private static SpreadsheetThemeResolver _themeResolver = null;

    public static void setThemeRegistry(SpreadsheetThemeRegistry themeRegistry) {
        _themeRegistry = themeRegistry;
    }

    public static SpreadsheetThemeRegistry getThemeRegistry() {
        return _themeRegistry;
    }

    public static SpreadsheetThemeResolver getThemeResolver() {
        return _themeResolver;
    }

    public static void setThemeResolver(SpreadsheetThemeResolver themeResolver) {
        _themeResolver = themeResolver;
    }

    public static String getCurrentTheme() {
        String t = SpreadsheetThemeFns.getTheme();
        if (_themeRegistry.hasTheme(t)) {
            return t;
        }
        t = Library.getProperty((String)SPREADSHEET_THEME_PREFERRED_KEY);
        if (_themeRegistry.hasTheme(t)) {
            return t;
        }
        Theme[] themes = _themeRegistry.getThemes();
        SpreadsheetStandardTheme highest = null;
        Comparator<SpreadsheetStandardTheme> comparator = SpreadsheetStandardTheme.getComparator();
        for (Theme theme : themes) {
            if (!(theme instanceof SpreadsheetStandardTheme) || comparator.compare((SpreadsheetStandardTheme)theme, highest) >= 0) continue;
            highest = (SpreadsheetStandardTheme)theme;
        }
        return highest != null ? highest.getName() : "default";
    }

    private static String getTheme() {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (!(request instanceof HttpServletRequest)) {
            return "iceblue";
        }
        return _themeResolver.getTheme((HttpServletRequest)request);
    }
}

