/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.InvalidDataValidationException;
import io.keikai.model.SCell;
import io.keikai.model.SDataValidation;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import java.io.Serializable;
import java.util.Date;
import org.zkoss.poi.ss.usermodel.ZssContext;

public class DataValidationVerificationHelper
implements Serializable {
    private static final long serialVersionUID = -5730156448383762080L;
    SDataValidation.ValidationType _validationType;
    boolean _ignoreBlank;
    SDataValidation.OperatorType _operatorType;
    boolean _inCellDropDown;
    String _formula1;
    String _formula2;
    boolean _showInput;
    String _inputTitle;
    String _inputMessage;
    boolean _showError;
    SDataValidation.AlertStyle _alertStyle;
    String _errorTitle;
    String _errorMessage;
    boolean _doubleFormula;

    public DataValidationVerificationHelper(SDataValidation.ValidationType validationType, boolean ignoreBlank, SDataValidation.OperatorType operatorType, boolean inCellDropDown, String formula1, String formula2, boolean showInput, String inputTitle, String inputMessage, boolean showError, SDataValidation.AlertStyle alertStyle, String errorTitle, String errorMessage) {
        this._validationType = validationType;
        this._ignoreBlank = ignoreBlank;
        this._operatorType = operatorType;
        this._inCellDropDown = inCellDropDown;
        this._formula1 = formula1;
        this._formula2 = formula2;
        this._showInput = showInput;
        this._inputTitle = inputTitle;
        this._inputMessage = inputMessage;
        this._showError = showError;
        this._alertStyle = alertStyle;
        this._errorTitle = errorTitle;
        this._errorMessage = errorMessage;
        this._doubleFormula = this._operatorType == SDataValidation.OperatorType.BETWEEN || this._operatorType == SDataValidation.OperatorType.NOT_BETWEEN;
    }

    public void verify() {
        InputEngine ie = EngineFactory.getInstance().createInputEngine();
        InputResult formula1Value = ie.parseInput(this._formula1 == null ? "" : this._formula1, "General", new InputParseContext(ZssContext.getCurrent().getLocale()));
        InputResult formula2Value = ie.parseInput(this._formula2 == null ? "" : this._formula2, "General", new InputParseContext(ZssContext.getCurrent().getLocale()));
        switch (this._validationType) {
            case INTEGER: {
                this.verifyInteger(formula1Value, formula2Value);
                break;
            }
            case TEXT_LENGTH: {
                this.verifyTextLength(formula1Value, formula2Value);
                break;
            }
            case DECIMAL: {
                this.verifyDecimal(formula1Value, formula2Value);
                break;
            }
            case DATE: {
                this.verifyDate(formula1Value, formula2Value);
                break;
            }
            case TIME: {
                this.verifyTime(formula1Value, formula2Value);
                break;
            }
        }
    }

    private void verifyDate(InputResult formula1Value, InputResult formula2Value) {
        boolean notFormula1;
        boolean notFormula2 = !this.isFormula(formula2Value);
        boolean bl = notFormula1 = !this.isFormula(formula1Value);
        if (this._doubleFormula && notFormula2 && !formula2Value.getValue().getClass().equals(Date.class)) {
            throw new InvalidDataValidationException("Formula should be a Date value.");
        }
        if (notFormula1 && !formula1Value.getValue().getClass().equals(Date.class)) {
            throw new InvalidDataValidationException("Formula should be a Date value.");
        }
        if (notFormula2 && notFormula1 && this._doubleFormula && ((Date)formula2Value.getValue()).getTime() < ((Date)formula1Value.getValue()).getTime()) {
            throw new InvalidDataValidationException("The End Date must be greater than or equal to the Start Date.");
        }
    }

    private void verifyTime(InputResult formula1Value, InputResult formula2Value) {
        boolean notFormula1;
        boolean notFormula2 = !this.isFormula(formula2Value);
        boolean bl = notFormula1 = !this.isFormula(formula1Value);
        if (this._doubleFormula && notFormula2 && !formula2Value.getValue().getClass().equals(Date.class)) {
            throw new InvalidDataValidationException("Formula should be a Time value.");
        }
        if (notFormula1 && !formula1Value.getValue().getClass().equals(Date.class)) {
            throw new InvalidDataValidationException("Formula should be a Time value.");
        }
        if (notFormula2 && notFormula1 && this._doubleFormula && ((Date)formula2Value.getValue()).getTime() < ((Date)formula1Value.getValue()).getTime()) {
            throw new InvalidDataValidationException("The End Time must be greater than or equal to the Start Time.");
        }
    }

    private void verifyDecimal(InputResult formula1Value, InputResult formula2Value) {
        boolean notFormula1;
        boolean notFormula2 = !this.isFormula(formula2Value);
        boolean bl = notFormula1 = !this.isFormula(formula1Value);
        if (this._doubleFormula && notFormula2 && formula2Value.getType() != SCell.CellType.NUMBER) {
            throw new InvalidDataValidationException("Formula should be a Decimal value.");
        }
        if (notFormula1 && formula1Value.getType() != SCell.CellType.NUMBER) {
            throw new InvalidDataValidationException("Formula should be a Decimal value.");
        }
        if (notFormula2 && notFormula1 && this._doubleFormula && (Double)formula2Value.getValue() < (Double)formula1Value.getValue()) {
            throw new InvalidDataValidationException("The Maximum must be greater than or equal to the Minimum.");
        }
    }

    private void verifyInteger(InputResult formula1Value, InputResult formula2Value) {
        try {
            Double value;
            boolean notFormula1;
            boolean notFormula2 = !this.isFormula(formula2Value);
            boolean bl = notFormula1 = !this.isFormula(formula1Value);
            if (this._doubleFormula && notFormula2 && (formula2Value.getType() != SCell.CellType.NUMBER || (value = (Double)formula2Value.getValue()) != (double)value.intValue())) {
                throw new InvalidDataValidationException("Formula should be a Whole number.");
            }
            if (notFormula1 && (formula1Value.getType() != SCell.CellType.NUMBER || (value = (Double)formula1Value.getValue()) != (double)value.intValue())) {
                throw new InvalidDataValidationException("Formula should be a Whole number.");
            }
            if (notFormula2 && notFormula1 && this._doubleFormula && (Double)formula2Value.getValue() < (Double)formula1Value.getValue()) {
                throw new InvalidDataValidationException("The Maximum must be greater than or equal to the Minimum.");
            }
        }
        catch (ClassCastException e) {
            throw new InvalidDataValidationException("Formula should be a Whole number.");
        }
    }

    private void verifyTextLength(InputResult formula1Value, InputResult formula2Value) {
        try {
            Double value;
            boolean notFormula1;
            boolean notFormula2 = !this.isFormula(formula2Value);
            boolean bl = notFormula1 = !this.isFormula(formula1Value);
            if (this._doubleFormula && notFormula2 && (formula2Value.getType() != SCell.CellType.NUMBER || (value = (Double)formula2Value.getValue()) != (double)value.intValue())) {
                throw new InvalidDataValidationException("Formula should be a integer.");
            }
            if (notFormula1 && (formula1Value.getType() != SCell.CellType.NUMBER || (value = (Double)formula1Value.getValue()) != (double)value.intValue())) {
                throw new InvalidDataValidationException("Formula should be a integer.");
            }
            if (notFormula2 && notFormula1 && this._doubleFormula && (Double)formula2Value.getValue() < (Double)formula1Value.getValue()) {
                throw new InvalidDataValidationException("The Maximum must be greater than or equal to the Minimum.");
            }
        }
        catch (ClassCastException e) {
            throw new InvalidDataValidationException("Formula should be a integer.");
        }
    }

    private boolean isFormula(InputResult formulaValue) {
        return formulaValue.getType() == SCell.CellType.FORMULA;
    }
}

