/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.AreaRef;
import io.keikai.api.model.Sheet;
import io.keikai.ui.AuxAction;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.AuxActionEvent;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class AuxActionCommand
extends AbstractCommand
implements Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(AuRequest request) {
        String sheetId;
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, AuxActionCommand.class);
        }
        Map data = request.getData();
        if (data == null || data.size() < 2) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), AuxActionCommand.class});
        }
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        String tag = (String)data.get("tag");
        String action = (String)data.get("action");
        AreaRef selection = this.getSelectionIfAny(data);
        Sheet sheet = null;
        if (selection == null) {
            selection = spreadsheet.getSelection();
        }
        if ("sheet".equals(tag) && spreadsheet.getSBook() != null) {
            sheetId = (String)data.get("sheetId");
            sheet = AuxActionCommand.getSheetByUuid(spreadsheet.getBook(), sheetId);
            if (sheet == null) {
                return;
            }
            if ("add".equals(action)) {
                action = AuxAction.ADD_SHEET.getAction();
            } else if ("delete".equals(action)) {
                action = AuxAction.DELETE_SHEET.getAction();
            } else if ("rename".equals(action)) {
                action = AuxAction.RENAME_SHEET.getAction();
            } else if ("copy".equals(action)) {
                action = AuxAction.COPY_SHEET.getAction();
            } else if ("protect".equals(action)) {
                action = AuxAction.PROTECT_SHEET.getAction();
            } else if ("hide".equals(action)) {
                action = AuxAction.HIDE_SHEET.getAction();
            } else if ("unhide".equals(action)) {
                action = AuxAction.UNHIDE_SHEET.getAction();
            } else if ("moveLeft".equals(action)) {
                action = AuxAction.MOVE_SHEET_LEFT.getAction();
            } else if ("moveRight".equals(action)) {
                action = AuxAction.MOVE_SHEET_RIGHT.getAction();
            } else if ("customFilters".equals(action)) {
                action = AuxAction.CUSTOM_FILTERS.getAction();
            } else {
                if (!"top10Filter".equals(action)) throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), AuxActionCommand.class});
                action = AuxAction.TOP10_FILTER.getAction();
            }
        } else if ("toolbar".equals(tag)) {
            sheet = spreadsheet.getSelectedSheet();
        } else if ("column".equals(tag) && spreadsheet.getSBook() != null) {
            sheetId = (String)data.get("sheetId");
            sheet = AuxActionCommand.getSheetByUuid(spreadsheet.getBook(), sheetId);
            if (sheet == null) {
                return;
            }
            if ("add".equals(action)) {
                action = AuxAction.ADD_COLUMN.getAction();
            }
        } else {
            if (!"row".equals(tag)) throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), AuxActionCommand.class});
            sheetId = (String)data.get("sheetId");
            sheet = AuxActionCommand.getSheetByUuid(spreadsheet.getBook(), sheetId);
            if (sheet == null) {
                return;
            }
            if ("add".equals(action)) {
                action = AuxAction.ADD_ROW.getAction();
            }
        }
        AuxActionEvent evt = new AuxActionEvent("onAuxAction", (Component)spreadsheet, sheet, action, selection, data);
        Events.postEvent((Event)evt);
    }

    private AreaRef getSelectionIfAny(Map data) {
        if (data.containsKey("tRow") && data.containsKey("tRow") && data.containsKey("tRow") && data.containsKey("tRow")) {
            int tRow = (Integer)data.get("tRow");
            int bRow = (Integer)data.get("bRow");
            int lCol = (Integer)data.get("lCol");
            int rCol = (Integer)data.get("rCol");
            AreaRef r = new AreaRef(tRow, lCol, bRow, rCol);
            return r;
        }
        return null;
    }
}

