/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.WorkbookDependentFormula;
import org.zkoss.poi.ss.formula.ptg.ExternSheetNameResolver;
import org.zkoss.poi.ss.formula.ptg.OperandPtg;
import org.zkoss.poi.ss.formula.ptg.Ref3DPtg;
import org.zkoss.poi.ss.usermodel.ErrorConstants;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class DeletedRef3DPtg
extends OperandPtg
implements WorkbookDependentFormula {
    public static final byte sid = 60;
    private final int field_1_index_extern_sheet;
    private final int unused1;
    private final Ref3DPtg ptg;
    private final String bookName;

    public DeletedRef3DPtg(LittleEndianInput in) {
        this.field_1_index_extern_sheet = in.readUShort();
        this.unused1 = in.readInt();
        this.ptg = null;
        this.bookName = null;
    }

    public DeletedRef3DPtg(int externSheetIndex) {
        this.field_1_index_extern_sheet = externSheetIndex;
        this.unused1 = 0;
        this.ptg = null;
        this.bookName = null;
    }

    @Override
    public String toFormulaString(FormulaRenderingWorkbook book) {
        if (this.ptg == null) {
            return ExternSheetNameResolver.prependSheetName(book, this.field_1_index_extern_sheet, this.ptg == null ? ErrorConstants.getText(23) : this.ptg.format2DRefAsString());
        }
        StringBuffer sb = new StringBuffer();
        if (this.bookName != null) {
            sb.append("[").append(this.bookName).append("]#REF");
        } else {
            sb.append("#REF");
        }
        return sb.append('!').append(this.ptg.format2DRefAsString()).toString();
    }

    @Override
    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }

    @Override
    public byte getDefaultOperandClass() {
        return 0;
    }

    @Override
    public int getSize() {
        return 7;
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(60 + this.getPtgClass());
        out.writeShort(this.field_1_index_extern_sheet);
        out.writeInt(this.unused1);
    }

    @Override
    public String toInternalFormulaString(FormulaRenderingWorkbook book) {
        return ExternSheetNameResolver.prependInternalSheetName(book, this.field_1_index_extern_sheet, ErrorConstants.getText(23));
    }

    public DeletedRef3DPtg(int externSheetIndex, Ref3DPtg ptg, String bookName) {
        this.field_1_index_extern_sheet = externSheetIndex;
        this.unused1 = 0;
        this.ptg = ptg;
        this.bookName = bookName;
    }
}

