/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.session;

import java.lang.ref.WeakReference;
import java.util.Properties;
import org.adempiere.webui.IWebClient;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.desktop.IDesktop;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Desktop;

public class SessionManager {
    public static final String SESSION_APPLICATION = "SessionApplication";

    public static boolean isUserLoggedIn(Properties ctx) {
        String adUserId = Env.getContext((Properties)ctx, (String)"#AD_User_ID");
        String adRoleId = Env.getContext((Properties)ctx, (String)"#AD_Role_ID");
        String adClientId = Env.getContext((Properties)ctx, (String)"#AD_Client_ID");
        String adOrgId = Env.getContext((Properties)ctx, (String)"#AD_Org_ID");
        String mfaId = Env.getContext((Properties)ctx, (String)"#MFA_Registration_ID");
        return !"".equals(mfaId) && !"".equals(adOrgId) && !"".equals(adUserId) && !"".equals(adRoleId) && !"".equals(adClientId);
    }

    public static void setSessionApplication(IWebClient app) {
        Desktop desktop = AEnv.getDesktop();
        if (desktop != null) {
            desktop.setAttribute(SESSION_APPLICATION, new WeakReference<IWebClient>(app));
        }
    }

    public static IDesktop getAppDesktop() {
        IWebClient webClient = SessionManager.getSessionApplication();
        return webClient != null ? webClient.getAppDeskop() : null;
    }

    public static IWebClient getSessionApplication() {
        Desktop desktop = AEnv.getDesktop();
        IWebClient app = null;
        if (desktop != null) {
            WeakReference wref = (WeakReference)desktop.getAttribute(SESSION_APPLICATION);
            app = wref != null ? (IWebClient)wref.get() : null;
        }
        return app;
    }

    public static void logoutSession() {
        IWebClient app = SessionManager.getSessionApplication();
        if (app != null) {
            app.logout();
        }
    }

    public static void logoutSessionAfterBrowserDestroyed() {
        IWebClient app = SessionManager.getSessionApplication();
        if (app != null) {
            app.logoutAfterTabDestroyed();
        }
    }

    public static void changeRole(MUser user) {
        IWebClient app = SessionManager.getSessionApplication();
        if (app != null) {
            app.changeRole(user);
        }
    }
}

