/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Comparator;
import org.compiere.util.Language;
import org.compiere.util.NamePair;

public final class SortComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 1265701980018071753L;
    private int columnIndex;
    private int m_multiplier = 1;
    private Collator m_collator = null;

    public SortComparator(int columnIndex, boolean ascending, Language language) {
        this.m_collator = Collator.getInstance(language.getLocale());
        this.setSortAsc(ascending);
        this.columnIndex = columnIndex;
    }

    public void setSortAsc(boolean ascending) {
        this.m_multiplier = ascending ? 1 : -1;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object cmp2;
        Object cmp1 = o1;
        if (cmp1 instanceof NamePair) {
            cmp1 = ((NamePair)cmp1).getName();
        }
        if ((cmp2 = o2) instanceof NamePair) {
            cmp2 = ((NamePair)cmp2).getName();
        }
        if (cmp1 == null) {
            if (cmp2 == null) {
                return 0;
            }
            return -1 * this.m_multiplier;
        }
        if (cmp2 == null) {
            return 1 * this.m_multiplier;
        }
        if (cmp1 instanceof String && cmp2 instanceof String) {
            return this.m_collator.compare(cmp1, cmp2) * this.m_multiplier;
        }
        if (cmp1 instanceof Timestamp && cmp2 instanceof Timestamp) {
            Timestamp t = (Timestamp)cmp1;
            return t.compareTo((Timestamp)cmp2) * this.m_multiplier;
        }
        if (cmp1 instanceof BigDecimal && cmp2 instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)cmp1;
            return d.compareTo((BigDecimal)cmp2) * this.m_multiplier;
        }
        if (cmp1 instanceof Integer && cmp2 instanceof Integer) {
            Integer d = (Integer)cmp1;
            return d.compareTo((Integer)cmp2) * this.m_multiplier;
        }
        if (cmp1 instanceof Double && cmp2 instanceof Double) {
            Double d = (Double)cmp1;
            return d.compareTo((Double)cmp2) * this.m_multiplier;
        }
        String s = cmp1.toString();
        return this.m_collator.compare(s, cmp2.toString()) * this.m_multiplier;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }
}

