/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.util.LogAuthFailure;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ComboItem;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.LoginWindow;
import org.compiere.model.MMFAMethod;
import org.compiere.model.MMFARegisteredDevice;
import org.compiere.model.MMFARegistration;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.Div;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Image;

public class ValidateMFAPanel
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 4777197666886479162L;
    private static final CLogger logger = CLogger.getCLogger(ValidateMFAPanel.class);
    protected LoginWindow wndLogin;
    protected Login login;
    protected Properties m_ctx;
    protected Label lblMFAMechanism;
    protected Combobox lstMFAMechanism;
    protected Label lblMFAMsg;
    protected Label lblValidationCode;
    protected Textbox txtValidationCode;
    protected Checkbox chkSetPreferred;
    protected Checkbox chkRegisterDevice = null;
    private KeyNamePair m_orgKNPair;
    private KeyNamePair[] m_clientsKNPairs;
    private boolean m_isClientDefined;
    private String m_userName;
    private boolean m_showRolePanel = true;
    private boolean m_showMFAPanel = false;
    private boolean m_autoCall = false;
    private static LogAuthFailure logAuthFailure = new LogAuthFailure();
    private int failures = 0;

    public ValidateMFAPanel(Properties ctx, LoginWindow loginWindow, KeyNamePair orgKNPair, boolean isClientDefined, String userName, boolean showRolePanel, KeyNamePair[] clientsKNPairs) {
        this.wndLogin = loginWindow;
        this.m_ctx = ctx;
        this.m_orgKNPair = orgKNPair;
        this.m_isClientDefined = isClientDefined;
        this.m_userName = userName;
        this.m_showRolePanel = showRolePanel;
        this.m_clientsKNPairs = clientsKNPairs;
        String registerCookie = ValidateMFAPanel.getCookie(this.getCookieName());
        this.login = new Login(ctx);
        if (this.login.isMFARequired(registerCookie)) {
            this.initComponents(registerCookie != null);
            this.init();
            this.setId("validateMFAPanel");
            this.setSclass("login-box");
            AuFocus auf = new AuFocus((Component)this.lstMFAMechanism);
            Clients.response((AuResponse)auf);
            if (this.m_autoCall) {
                this.validateMFAComplete(true);
            } else {
                this.m_showMFAPanel = true;
            }
        } else {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("MFA not required");
            }
            this.validateMFAComplete(false);
        }
    }

    private void init() {
        Div div = new Div();
        div.setSclass("login-box-header");
        Label label = new Label(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginValidationHeader"));
        label.setSclass("login-box-header-txt");
        div.appendChild((Component)label);
        this.appendChild((Component)div);
        Table table = new Table();
        table.setId("grdMFAValidate");
        table.setDynamicProperty("cellpadding", (Object)"0");
        table.setDynamicProperty("cellspacing", (Object)"5");
        table.setSclass("login-box-body");
        this.appendChild((Component)table);
        Tr tr = new Tr();
        table.appendChild((Component)tr);
        Td td = new Td();
        td.setSclass("login-box-header-logo");
        tr.appendChild((Component)td);
        td.setDynamicProperty("colspan", (Object)"2");
        Image image = new Image();
        image.setSrc(ThemeManager.getLargeLogo());
        td.appendChild((Component)image);
        tr = new Tr();
        tr.setId("rowMFAMechanism");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblMFAMechanism);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstMFAMechanism);
        tr = new Tr();
        tr.setId("rowMFAMsg");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)new Label(""));
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-field");
        td.appendChild((Component)this.lblMFAMsg);
        tr = new Tr();
        tr.setId("rowValidationCode");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblValidationCode);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtValidationCode);
        tr = new Tr();
        tr.setId("rowSetPreferred");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)new Label(""));
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.chkSetPreferred);
        tr = new Tr();
        tr.setId("rowRegisterDevice");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)new Label(""));
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.chkRegisterDevice);
        div = new Div();
        div.setSclass("login-box-footer");
        ConfirmPanel pnlButtons = new ConfirmPanel(true);
        pnlButtons.addActionListener(this);
        LayoutUtils.addSclass("login-box-footer-pnl", (HtmlBasedComponent)pnlButtons);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlButtons, null);
        pnlButtons.getButton("Ok").setSclass("login-btn");
        pnlButtons.getButton("Cancel").setSclass("login-btn");
        div.appendChild((Component)pnlButtons);
        this.appendChild((Component)div);
    }

    private void initComponents(boolean hasCookie) {
        this.lblMFAMechanism = new Label();
        this.lblMFAMechanism.setId("lblMFAMechanism");
        this.lblMFAMechanism.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginMechanism"));
        this.lblValidationCode = new Label();
        this.lblValidationCode.setId("lblValidationCode");
        this.lblValidationCode.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginValidationCode"));
        this.lblMFAMsg = new Label();
        this.lblMFAMsg.setId("lblMFAMsg");
        this.lblMFAMsg.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginMessage"));
        this.lstMFAMechanism = new Combobox();
        this.lstMFAMechanism.setAutocomplete(true);
        this.lstMFAMechanism.setAutodrop(true);
        this.lstMFAMechanism.setId("lstMFAMechanism");
        List regs = MMFARegistration.getValidRegistrationsFromUser();
        for (MMFARegistration reg : regs) {
            String id;
            MMFAMethod method = new MMFAMethod(this.m_ctx, reg.getMFA_Method_ID(), reg.get_TrxName());
            if (regs.size() == 1 && "TOTP".equals(method.getMethod())) {
                this.m_autoCall = true;
            }
            ComboItem ci = new ComboItem(reg.getName() + " - " + method.getMethod(), reg.getMFA_Registration_ID());
            if (SystemProperties.isZkUnitTest() && this.lstMFAMechanism.getFellowIfAny(id = AdempiereIdGenerator.escapeId(ci.getLabel())) == null) {
                ci.setId(id);
            }
            this.lstMFAMechanism.appendChild((Component)ci);
        }
        this.lstMFAMechanism.setSelectedIndex(0);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstMFAMechanism, "220px");
        this.chkSetPreferred = new Checkbox(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginSetPreferred"));
        this.chkSetPreferred.setId("chkSetPreferred");
        boolean enablePreferred = this.lstMFAMechanism.getChildren().size() > 1 && this.lstMFAMechanism.getSelectedIndex() > 0;
        this.chkSetPreferred.setVisible(enablePreferred);
        this.chkSetPreferred.setChecked(false);
        int daysExpire = MSysConfig.getIntValue((String)"MFA_REGISTERED_DEVICE_EXPIRATION_DAYS", (int)30, (int)Env.getAD_Client_ID((Properties)this.m_ctx));
        this.chkRegisterDevice = new Checkbox(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginRegisterDevice", (Object[])new Object[]{daysExpire}));
        this.chkRegisterDevice.setId("chkRegisterDevice");
        boolean enableRegisterDevice = daysExpire > 0;
        this.chkRegisterDevice.setVisible(enableRegisterDevice);
        this.chkRegisterDevice.setChecked(hasCookie);
        this.txtValidationCode = new Textbox();
        this.txtValidationCode.setId("txtValidationCode");
        this.txtValidationCode.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtValidationCode, "220px");
        this.txtValidationCode.setDisabled(true);
    }

    public void onEvent(Event event) {
        if (event.getTarget().getId().equals("Ok")) {
            this.validateMFAComplete(true);
        } else if (event.getTarget().getId().equals("Cancel")) {
            SessionManager.logoutSession();
        }
    }

    public void validateMFAComplete(boolean required) {
        Clients.clearBusy();
        int registrationId = 0;
        if (required) {
            registrationId = (Integer)this.lstMFAMechanism.getSelectedItem().getValue();
            boolean enablePreferred = this.lstMFAMechanism.getChildren().size() > 1 && this.lstMFAMechanism.getSelectedIndex() > 0;
            this.chkSetPreferred.setVisible(enablePreferred);
            MMFARegistration reg = new MMFARegistration(Env.getCtx(), registrationId, null);
            this.m_showMFAPanel = true;
            if (this.txtValidationCode.isDisabled()) {
                String msg = reg.generateValidationCode(reg);
                this.lblMFAMsg.setValue(msg);
                this.txtValidationCode.setDisabled(false);
                this.lstMFAMechanism.setDisabled(true);
                AuFocus auf = new AuFocus((Component)this.txtValidationCode);
                Clients.response((AuResponse)auf);
                return;
            }
            if (Util.isEmpty((String)this.txtValidationCode.getText()) && this.lstMFAMechanism.getItemCount() > 1) {
                this.lblMFAMsg.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"MFALoginMessage"));
                this.txtValidationCode.setDisabled(true);
                this.lstMFAMechanism.setDisabled(false);
                AuFocus auf = new AuFocus((Component)this.lstMFAMechanism);
                Clients.response((AuResponse)auf);
                return;
            }
            String msg = reg.validateCode(reg, this.txtValidationCode.getText(), this.chkSetPreferred.isChecked());
            if (msg != null) {
                String x_Forward_IP = Executions.getCurrent().getHeader("X-Forwarded-For");
                if (x_Forward_IP == null) {
                    x_Forward_IP = Executions.getCurrent().getRemoteAddr();
                }
                MUser user = MUser.get((Properties)this.m_ctx);
                boolean email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
                logAuthFailure.log(x_Forward_IP, "/webui", email_login ? user.getEMail() : user.getName(), msg);
                try {
                    Thread.sleep(this.failures * 2000);
                }
                catch (InterruptedException interruptedException) {}
                ++this.failures;
                AuFocus auf = new AuFocus((Component)this.txtValidationCode);
                Clients.response((AuResponse)auf);
                throw new WrongValueException((Component)this.txtValidationCode, msg);
            }
        }
        if (this.chkRegisterDevice != null && this.chkRegisterDevice.isChecked()) {
            String cookieValue = UUID.randomUUID().toString();
            ValidateMFAPanel.setCookie(this.getCookieName(), cookieValue);
            MUser user = MUser.get((Properties)Env.getCtx());
            MMFARegisteredDevice rd = new MMFARegisteredDevice(this.m_ctx, 0, null);
            rd.set_ValueOfColumn("AD_Client_ID", (Object)user.getAD_Client_ID());
            rd.setAD_Org_ID(0);
            rd.setAD_User_ID(user.getAD_User_ID());
            rd.setMFADeviceIdentifier(cookieValue);
            long daysExpire = MSysConfig.getIntValue((String)"MFA_REGISTERED_DEVICE_EXPIRATION_DAYS", (int)30, (int)Env.getAD_Client_ID((Properties)this.m_ctx));
            rd.setExpiration(new Timestamp(System.currentTimeMillis() + daysExpire * 86400000L));
            rd.saveCrossTenantSafeEx();
        }
        Env.setContext((Properties)this.m_ctx, (String)"#MFA_Registration_ID", (int)registrationId);
        if (this.m_isClientDefined) {
            this.wndLogin.showRolePanel(this.m_userName, this.m_showRolePanel, this.m_clientsKNPairs, this.m_isClientDefined, true);
        } else if (this.m_orgKNPair == null) {
            this.wndLogin.showRolePanel(this.m_userName, this.m_showRolePanel, this.m_clientsKNPairs, this.m_isClientDefined, true);
        } else {
            this.wndLogin.loginCompleted(this.login, this.m_orgKNPair, this);
        }
    }

    private String getCookieName() {
        StringBuilder sb = new StringBuilder("UD_").append(Env.getAD_User_ID((Properties)this.m_ctx));
        return sb.toString();
    }

    public static void setCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(true);
        ((HttpServletResponse)Executions.getCurrent().getNativeResponse()).addCookie(cookie);
    }

    public static String getCookie(String name) {
        Cookie[] cookies = ((HttpServletRequest)Executions.getCurrent().getNativeRequest()).getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(name)) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean show() {
        return this.m_showMFAPanel;
    }
}

