/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessDrillRule;
import org.compiere.model.MReportView;
import org.compiere.model.Query;
import org.compiere.print.DrillReportCtl;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.A;
import org.zkoss.zhtml.H3;
import org.zkoss.zhtml.H4;
import org.zkoss.zhtml.P;
import org.zkoss.zhtml.Span;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.HtmlNativeComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;

public class WDrillReport
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 5143424676962140799L;
    private static final String DRILL_REPORT_PRINTFORMAT_ID_NAME = "AD_PrintFormat_ID";
    private static final String DRILL_PROCESS_RULE_ID_NAME = "AD_Process_DrillRule_ID";
    private static final String DRILL_REPORT_TABLE_NAME = "TableName";
    private DrillReportCtl drillReportCtl;
    private String winpref;
    private Tabpanel tabPanel;
    private Tab tableTab;
    private boolean tablesLoaded = false;
    private int windowNo = 0;

    public WDrillReport(DrillEvent.DrillData data, int windowNo) {
        this(data, windowNo, 0);
    }

    public WDrillReport(DrillEvent.DrillData data, int windowNo, int processID) {
        this.windowNo = windowNo;
        this.drillReportCtl = new DrillReportCtl(data.getQuery().getTableName(), data.getQuery(), data.getColumnName(), data.getValue(), data.getDisplayValue(), windowNo, processID);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"DrillAssistant"));
        this.setClosable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "60%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "70%");
        this.setAttribute("mode", "embedded");
        this.setSclass("help-window");
        this.setSizable(true);
        this.setMaximizable(true);
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        Div div = new Div();
        centerPane.appendChild((Component)div);
        div.setStyle("width: 100%; height: 100%; overflow: auto;");
        Table table2 = new Table();
        table2.setStyle("width: 100%;");
        div.appendChild((Component)table2);
        table2.setWidgetAttribute("cellspacing", "0");
        table2.setWidgetAttribute("cellpadding", "0");
        table2.setWidgetAttribute("border", "0");
        Tr tr2 = new Tr();
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.getHeader());
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.getContent());
    }

    private Table getHeader() {
        Table table2 = new Table();
        table2.setWidgetAttribute("cellspacing", "0");
        table2.setWidgetAttribute("cellpadding", "0");
        table2.setWidgetAttribute("border", "0");
        table2.setStyle("width: 100%;");
        table2.setWidgetAttribute("class", "help-window-header");
        Tr tr2 = new Tr();
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        td2.setWidgetAttribute("class", "help-window-title");
        tr2.appendChild((Component)td2);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("ddHHmmss");
        String dt = sdf.format(cal.getTime());
        this.winpref = "Win" + dt;
        A a2 = new A();
        a2.setWidgetAttribute("name", this.winpref);
        td2.appendChild((Component)a2);
        StringBuilder title = new StringBuilder(Msg.getMsg((Properties)Env.getCtx(), (String)"DrillColumn")).append(": ").append(this.drillReportCtl.getTableName()).append(" - ").append(!Util.isEmpty((String)this.drillReportCtl.getDisplayValue()) ? this.drillReportCtl.getDisplayValue() : this.drillReportCtl.getValue());
        H3 h32 = new H3();
        h32.appendChild((Component)new Text(title.toString()));
        td2.appendChild((Component)h32);
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.setWidgetAttribute("class", "help-window-tabs");
        tr2.appendChild((Component)td2);
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        return table2;
    }

    private Tabbox getContent() {
        Tabbox tabbox = new Tabbox();
        Tabs tabs = new Tabs();
        tabbox.appendChild((Component)tabs);
        Tabpanels tabpanels = new Tabpanels();
        tabbox.appendChild((Component)tabpanels);
        Tab tab = new Tab(Msg.getElement((Properties)Env.getCtx(), (String)DRILL_PROCESS_RULE_ID_NAME));
        tabs.appendChild((Component)tab);
        tab = new Tab(Msg.getElement((Properties)Env.getCtx(), (String)"AD_Table_ID"));
        tab.addEventListener("onSelect", this);
        tabs.appendChild((Component)tab);
        this.tableTab = tab;
        Tabpanel tabPanel = new Tabpanel();
        tabPanel.appendChild((Component)this.getTabContent(1, this.drillReportCtl.getDrillProcessList(), this.drillReportCtl.getDrillProcesRules(), true));
        tabpanels.appendChild((Component)tabPanel);
        tabPanel = new Tabpanel();
        tabpanels.appendChild((Component)tabPanel);
        this.tabPanel = tabPanel;
        if (this.drillReportCtl.getDrillProcessList().length <= 0) {
            tabbox.setSelectedIndex(1);
            this.drillReportCtl.initDrillTableMap();
            tabPanel.appendChild((Component)this.getTabContent(2, this.drillReportCtl.getDrillTables(), null, false));
            this.tablesLoaded = true;
        }
        return tabbox;
    }

    private Table getTabContent(int tabIndex, KeyNamePair[] drillTables, HashMap<Integer, KeyNamePair[]> drillPrintFormatMap, boolean isDrillProcessRule) {
        Table table2 = new Table();
        table2.setWidgetAttribute("cellspacing", "0");
        table2.setWidgetAttribute("cellpadding", "0");
        table2.setWidgetAttribute("border", "0");
        table2.setStyle("width: 100%;");
        table2.setWidgetAttribute("class", "help-window-content-r");
        Tr tr2 = null;
        Td td2 = null;
        int size = drillTables.length;
        if (size <= 0) {
            tr2 = new Tr();
            table2.appendChild((Component)tr2);
            td2 = new Td();
            tr2.appendChild((Component)td2);
            String message = isDrillProcessRule ? "NoDrillRuleFound" : "NoTableWithDrillOptions";
            Span span = new Span();
            span.appendChild((Component)new Text(Msg.getMsg((Properties)Env.getCtx(), (String)message)));
            td2.setStyle("text-align: center;");
            td2.appendChild((Component)span);
        } else {
            tr2 = new Tr();
            table2.appendChild((Component)tr2);
            td2 = new Td();
            tr2.appendChild((Component)td2);
            A a2 = new A();
            a2.setWidgetAttribute("name", this.winpref + "Tables");
            td2.appendChild((Component)a2);
            td2.appendChild((Component)this.getTablesBox(tabIndex, drillTables));
            int i = 0;
            while (i < size) {
                KeyNamePair drillTable = drillTables[i];
                tr2 = new Tr();
                table2.appendChild((Component)tr2);
                td2 = new Td();
                tr2.appendChild((Component)td2);
                td2.appendChild((Component)this.getDrillTableBox(drillTable, i, tabIndex, drillPrintFormatMap, isDrillProcessRule));
                ++i;
            }
        }
        return table2;
    }

    private Table getDrillTableBox(KeyNamePair drillTable, int tabIndex, int groupIndex, HashMap<Integer, KeyNamePair[]> drillPrintFormatMap, boolean isDrillProcessRule) {
        KeyNamePair[] keyNamePairArray;
        Table table2 = new Table();
        table2.setWidgetAttribute("cellspacing", "0");
        table2.setWidgetAttribute("cellpadding", "0");
        table2.setWidgetAttribute("border", "0");
        table2.setStyle("width: 100%; margin-top: 25px;");
        table2.setWidgetAttribute("class", "drill-window-tab");
        Tr tr2 = new Tr();
        tr2.setWidgetAttribute("class", "help-window-tab-header");
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        td2.setWidgetAttribute("class", "help-window-tab-name");
        td2.setColspan(Integer.valueOf(4));
        tr2.appendChild((Component)td2);
        A a2 = new A();
        a2.setWidgetAttribute("name", this.winpref + "Rep" + tabIndex + "-" + groupIndex);
        td2.appendChild((Component)a2);
        Div header = new Div();
        header.setStyle("padding: 10px 0px 10px 0px");
        HtmlNativeComponent h32 = new HtmlNativeComponent("h3", drillTable.getName(), "");
        header.appendChild((Component)h32);
        td2.appendChild((Component)header);
        a2 = new A();
        a2.setWidgetAttribute("title", "Up one level");
        a2.setHref("#" + this.winpref);
        a2.appendChild((Component)new Text(".."));
        header.appendChild((Component)a2);
        if (drillPrintFormatMap != null) {
            keyNamePairArray = drillPrintFormatMap.get(drillTable.getKey());
        } else {
            KeyNamePair[] keyNamePairArray2 = new KeyNamePair[1];
            keyNamePairArray = keyNamePairArray2;
            keyNamePairArray2[0] = this.findTablePrintFormat(drillTable);
        }
        KeyNamePair[] drillRules = keyNamePairArray;
        int j = 0;
        while (j < drillRules.length) {
            KeyNamePair[] keyNamePairArray3;
            KeyNamePair drillRule = drillRules[j];
            if (isDrillProcessRule) {
                keyNamePairArray3 = this.drillReportCtl.getDrillProcessRulesPrintFormatMap(drillRule.getKey());
            } else {
                KeyNamePair[] keyNamePairArray4 = new KeyNamePair[1];
                keyNamePairArray3 = keyNamePairArray4;
                keyNamePairArray4[0] = drillRule;
            }
            KeyNamePair[] printFormats = keyNamePairArray3;
            if (printFormats.length <= 0 && isDrillProcessRule) {
                KeyNamePair[] pfArray = new KeyNamePair[1];
                MPrintFormat pf = null;
                MProcessDrillRule dr = MProcessDrillRule.get((Properties)Env.getCtx(), (int)drillRule.getKey());
                if (dr != null) {
                    int AD_ReportView_ID = dr.getAD_ReportView_ID();
                    if (AD_ReportView_ID == 0) {
                        AD_ReportView_ID = MProcess.get((int)dr.getAD_Process_ID()).getAD_ReportView_ID();
                    }
                    if (AD_ReportView_ID != 0) {
                        String name = MReportView.get((int)AD_ReportView_ID).getName();
                        pf = MPrintFormat.createFromReportView((Properties)Env.getCtx(), (int)AD_ReportView_ID, (String)name);
                    } else {
                        int AD_Table_ID = dr.getAD_Table_ID();
                        pf = MPrintFormat.createFromTable((Properties)Env.getCtx(), (int)AD_Table_ID);
                    }
                    if (pf != null) {
                        pfArray[0] = new KeyNamePair(pf.getAD_PrintFormat_ID(), pf.getName());
                    }
                    printFormats = pfArray;
                }
                if (printFormats.length <= 0) {
                    int AD_Table_ID = new Query(Env.getCtx(), "AD_Table", " Name = ? ", null).setParameters(new Object[]{drillRule.getName()}).firstId();
                    pf = MPrintFormat.createFromTable((Properties)Env.getCtx(), (int)AD_Table_ID);
                    pfArray[0] = new KeyNamePair(pf.getAD_PrintFormat_ID(), pf.getName());
                    printFormats = pfArray;
                }
            }
            KeyNamePair[] keyNamePairArray5 = printFormats;
            int n = printFormats.length;
            int n2 = 0;
            while (n2 < n) {
                KeyNamePair printFormat = keyNamePairArray5[n2];
                String hdr = printFormat.getName();
                if (hdr != null && hdr.length() > 0) {
                    table2.appendChild((Component)this.getPrintFormatBox(printFormat, tabIndex, j, tabIndex, (KeyNamePair)(isDrillProcessRule ? drillTable : null), drillRule, printFormats.length == 1));
                }
                ++n2;
            }
            ++j;
        }
        return table2;
    }

    private KeyNamePair findTablePrintFormat(KeyNamePair drillTable) {
        Integer printFormatID = new Query(Env.getCtx(), "AD_PrintFormat", " AD_Table_ID = ? AND AD_Client_ID IN (0,?) ", null).setOrderBy(" IsDefault DESC, Created DESC ").setParameters(new Object[]{drillTable.getKey(), Env.getAD_Client_ID((Properties)Env.getCtx())}).firstId();
        return new KeyNamePair(printFormatID != null && printFormatID > 0 ? printFormatID : 0, drillTable.getName());
    }

    private Table getTablesBox(int tabIndex, KeyNamePair[] drillTables) {
        Table table2 = new Table();
        table2.setWidgetAttribute("cellspacing", "0");
        table2.setWidgetAttribute("cellpadding", "0");
        table2.setWidgetAttribute("border", "0");
        table2.setStyle("width: 100%;");
        table2.setWidgetAttribute("class", "help-window-fields");
        Tr tr2 = new Tr();
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        tr2.appendChild((Component)td2);
        tr2 = new Tr();
        tr2.setWidgetAttribute("class", "help-window-Formats-link");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        P p2 = new P();
        td2.appendChild((Component)p2);
        int j = 0;
        while (j < drillTables.length) {
            KeyNamePair printFormat = drillTables[j];
            String hdr = printFormat.getName();
            if (hdr != null && hdr.length() > 0) {
                if (j > 0) {
                    p2.appendChild((Component)new Text(" "));
                }
                A a2 = new A();
                a2.setHref("#" + this.winpref + "Rep" + j + "-" + tabIndex);
                a2.appendChild((Component)new Text(hdr));
                p2.appendChild((Component)a2);
                if (j + 1 < drillTables.length) {
                    p2.appendChild((Component)new Text(" , "));
                }
            }
            ++j;
        }
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        return table2;
    }

    private Tr getPrintFormatBox(KeyNamePair drillPrintFormat, int reportIndex, int formatIndex, int groupIndex, KeyNamePair drillTable, KeyNamePair drillRule, boolean isSinglePrintFormat) {
        MPrintFormat pf;
        MProcessDrillRule dr;
        Tr tr2 = new Tr();
        tr2.setWidgetAttribute("class", "drill-window-field-name");
        Td td2 = new Td();
        td2.setStyle("width: 30%");
        tr2.appendChild((Component)td2);
        A a2 = new A();
        a2.setWidgetAttribute("name", this.winpref + "Format" + reportIndex + "-" + formatIndex + "-" + groupIndex);
        td2.appendChild((Component)a2);
        H4 h42 = new H4();
        h42.appendChild((Component)new Text(drillPrintFormat.getName()));
        td2.appendChild((Component)h42);
        a2 = new A();
        a2.setHref("#" + this.winpref + "Rep" + reportIndex + "-" + groupIndex);
        a2.setWidgetAttribute("title", "Up one level");
        a2.appendChild((Component)new Text(".."));
        td2.appendChild((Component)a2);
        td2 = new Td();
        td2.setStyle("width: 10%");
        tr2.appendChild((Component)td2);
        a2 = new A();
        a2.setWidgetAttribute("title", "Run Report");
        a2.setHref("#");
        a2.appendChild((Component)new Text("[" + Msg.getMsg((Properties)Env.getCtx(), (String)"Run") + "]"));
        a2.addEventListener("onClick", (EventListener)this);
        a2.setAttribute(DRILL_REPORT_PRINTFORMAT_ID_NAME, (Object)drillPrintFormat.getKey());
        a2.setAttribute(DRILL_REPORT_TABLE_NAME, (Object)drillPrintFormat.getName());
        if (drillTable != null) {
            a2.setAttribute(DRILL_PROCESS_RULE_ID_NAME, (Object)drillRule.getKey());
        }
        td2.appendChild((Component)a2);
        String description = "";
        if (drillTable != null && isSinglePrintFormat && (dr = MProcessDrillRule.get((Properties)Env.getCtx(), (int)drillRule.getKey())) != null && !Util.isEmpty((String)dr.getDescription())) {
            description = dr.getDescription();
        }
        if (Util.isEmpty((String)description) && (pf = MPrintFormat.get((int)drillPrintFormat.getKey())) != null && !Util.isEmpty((String)pf.getDescription())) {
            description = pf.getDescription();
        }
        td2 = new Td();
        td2.setStyle("width: 60");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)new Text(description));
        return tr2;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().equals((Object)this.tableTab) && !this.tablesLoaded) {
            this.drillReportCtl.initDrillTableMap();
            this.tabPanel.appendChild((Component)this.getTabContent(2, this.drillReportCtl.getDrillTables(), null, false));
            this.tablesLoaded = true;
        }
        if (event.getTarget().getAttribute(DRILL_REPORT_PRINTFORMAT_ID_NAME) != null) {
            if (event.getTarget().getAttribute(DRILL_PROCESS_RULE_ID_NAME) != null) {
                Integer processDrillRuleID = (Integer)event.getTarget().getAttribute(DRILL_PROCESS_RULE_ID_NAME);
                MProcessDrillRule drillRule = new MProcessDrillRule(Env.getCtx(), processDrillRuleID.intValue(), null);
                ProcessInfo pi = this.drillReportCtl.getDrillProcessProcessInfo(processDrillRuleID.intValue(), ((Integer)event.getTarget().getAttribute(DRILL_REPORT_PRINTFORMAT_ID_NAME)).intValue());
                String showHelp = drillRule.getShowHelp();
                showHelp = !Util.isEmpty((String)showHelp) ? showHelp : "S";
                pi.setShowHelp(showHelp);
                ProcessModalDialog processModalDialog = new ProcessModalDialog((EventListener<Event>)this, this.windowNo, false, pi);
                ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)processModalDialog, 850);
                this.appendChild((Component)processModalDialog);
                if (ClientInfo.isMobile()) {
                    processModalDialog.doHighlighted();
                } else {
                    LayoutUtils.openOverlappedWindow((Component)this, processModalDialog, "middle_center");
                }
                processModalDialog.focus();
            } else {
                this.drillReportCtl.launchTableDrillReport(((Integer)event.getTarget().getAttribute(DRILL_REPORT_PRINTFORMAT_ID_NAME)).intValue(), (String)event.getTarget().getAttribute(DRILL_REPORT_TABLE_NAME));
                this.onClose();
            }
            return;
        }
        if ("onWindowClose".equals(event.getName())) {
            this.onClose();
        }
    }
}

