/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletRequest;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.ISupportMask;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.DesktopRunnable;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.apps.WDrillReport;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.IServerPushCallback;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.window.Dialog;
import org.compiere.acct.Doc;
import org.compiere.model.GridWindowVO;
import org.compiere.model.Lookup;
import org.compiere.model.MClient;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MReference;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MZoomCondition;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Button;
import org.zkoss.zul.impl.InputElement;

public final class AEnv {
    public static final String LOCALE = "#Locale";
    private static int s_workflow_Window_ID = 0;
    private static final CLogger log = CLogger.getCLogger(AEnv.class);
    private static Map<String, CCache<Integer, GridWindowVO>> windowCache = new HashMap<String, CCache<Integer, GridWindowVO>>();
    private static String m_ApplicationUrl = null;

    public static void showCenterScreen(Window window) {
        if (SessionManager.getAppDesktop() != null) {
            SessionManager.getAppDesktop().showWindow(window, "center");
        } else {
            String mode;
            window.setPosition("center");
            window.setPage(AEnv.getDesktop().getFirstPage());
            Object objMode = window.getAttribute("mode");
            String string = mode = objMode != null ? objMode.toString() : "highlighted";
            if ("modal".equals(mode)) {
                window.doModal();
            } else {
                window.doHighlighted();
            }
        }
    }

    public static void showScreen(Window window, String position) {
        SessionManager.getAppDesktop().showWindow(window, position);
    }

    public static void showCenterWindow(Window parent, Window window) {
        parent.appendChild((Component)window);
        AEnv.showScreen(window, "parent,center");
    }

    public static char getMnemonic(String text) {
        int pos = text.indexOf(38);
        if (pos != -1) {
            return text.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static void zoom(int AD_Table_ID, int Record_ID) {
        int AD_Window_ID = Env.getZoomWindowID((int)AD_Table_ID, (int)Record_ID);
        if (AD_Window_ID == 0) {
            return;
        }
        MTable table2 = MTable.get((Properties)Env.getCtx(), (int)AD_Table_ID);
        MQuery query = MQuery.getEqualQuery((String)table2.getKeyColumns()[0], (int)Record_ID);
        query.setZoomTableName(table2.getTableName());
        query.setZoomColumnName(table2.getKeyColumns()[0]);
        query.setZoomValue((Object)Record_ID);
        AEnv.zoom(AD_Window_ID, query);
    }

    public static void zoomUU(int AD_Table_ID, String Record_UU) {
        int AD_Window_ID = Env.getZoomWindowUU((int)AD_Table_ID, (String)Record_UU);
        if (AD_Window_ID == 0) {
            return;
        }
        MTable table2 = MTable.get((Properties)Env.getCtx(), (int)AD_Table_ID);
        String uuColName = PO.getUUIDColumnName((String)table2.getTableName());
        MQuery query = MQuery.getEqualQuery((String)uuColName, (Object)Record_UU);
        query.setZoomTableName(table2.getTableName());
        query.setZoomColumnName(uuColName);
        query.setZoomValue((Object)Record_UU);
        AEnv.zoom(AD_Window_ID, query);
    }

    public static void zoom(int AD_Table_ID, int Record_ID, MQuery query, int windowNo) {
        int AD_Window_ID = Env.getZoomWindowID((int)AD_Table_ID, (int)Record_ID, (int)windowNo);
        if (AD_Window_ID == 0) {
            return;
        }
        AEnv.zoom(AD_Window_ID, query);
    }

    public static void zoomUU(int AD_Table_ID, String Record_UU, MQuery query, int windowNo) {
        int AD_Window_ID = Env.getZoomWindowUU((int)AD_Table_ID, (String)Record_UU, (int)windowNo);
        if (AD_Window_ID == 0) {
            return;
        }
        AEnv.zoom(AD_Window_ID, query);
    }

    public static void zoom(int AD_Table_ID, int Record_ID, MQuery query) {
        AEnv.zoom(AD_Table_ID, Record_ID, query, 0);
    }

    @Deprecated(forRemoval=true, since="11")
    public static void exit(int status) {
        Env.exitEnv((int)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logout() {
        MSession session;
        String sessionID = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        Map<String, CCache<Integer, GridWindowVO>> map = windowCache;
        synchronized (map) {
            CCache<Integer, GridWindowVO> cache = windowCache.get(sessionID);
            if (cache != null) {
                cache.clear();
                CacheMgt.get().unregister(cache);
            }
        }
        windowCache.remove(sessionID);
        int ad_Session_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        MSession mSession = session = ad_Session_ID > 0 ? new MSession(Env.getCtx(), ad_Session_ID, null) : null;
        if (session != null) {
            session.logout();
        }
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", null);
    }

    public static void startWorkflowProcess(int AD_Table_ID, int Record_ID) {
        if (s_workflow_Window_ID <= 0) {
            int AD_Window_ID;
            s_workflow_Window_ID = AD_Window_ID = DB.getSQLValue(null, (String)"SELECT AD_Window_ID FROM AD_Window WHERE Name = 'Workflow Process'");
        }
        if (s_workflow_Window_ID <= 0) {
            return;
        }
        MQuery query = new MQuery();
        query.addRestriction("AD_Table_ID", "=", AD_Table_ID);
        query.addRestriction("Record_ID", "=", Record_ID);
        AEnv.zoom(s_workflow_Window_ID, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridWindowVO getMWindowVO(int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        CCache cache;
        Map<String, CCache<Integer, GridWindowVO>> map;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        }
        GridWindowVO mWindowVO = null;
        String sessionID = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        if (AD_Window_ID != 0 && Ini.isCacheWindow()) {
            map = windowCache;
            synchronized (map) {
                cache = windowCache.get(sessionID);
                if (cache != null && (mWindowVO = (GridWindowVO)cache.get((Object)AD_Window_ID)) != null) {
                    mWindowVO = mWindowVO.clone(WindowNo);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Cached=" + String.valueOf(mWindowVO));
                    }
                }
            }
        }
        if (mWindowVO == null) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("create local");
            }
            if ((mWindowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)WindowNo, (int)AD_Window_ID, (int)AD_Menu_ID)) != null && Ini.isCacheWindow()) {
                map = windowCache;
                synchronized (map) {
                    cache = windowCache.get(sessionID);
                    if (cache == null) {
                        cache = new CCache("AD_Window", "AD_Window|GridWindowVO|Session|" + sessionID, 10);
                        windowCache.put(sessionID, (CCache<Integer, GridWindowVO>)cache);
                    }
                    cache.put((Object)AD_Window_ID, (Object)mWindowVO);
                }
            }
        }
        if (mWindowVO == null) {
            return null;
        }
        if (!mWindowVO.ctx.equals(Env.getCtx())) {
            Enumeration<Object> keyEnum = mWindowVO.ctx.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (!key.startsWith(WindowNo + "|")) continue;
                String value = mWindowVO.ctx.getProperty(key);
                Env.setContext((Properties)Env.getCtx(), (String)key, (String)value);
            }
            mWindowVO.setCtx(Env.getCtx());
        }
        return mWindowVO;
    }

    public static String postImmediate(int WindowNo, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        log.info("Window=" + WindowNo + ", AD_Table_ID=" + AD_Table_ID + "/" + Record_ID + ", Force=" + force);
        return Doc.manualPosting((int)WindowNo, (int)AD_Client_ID, (int)AD_Table_ID, (int)Record_ID, (boolean)force);
    }

    public static void cacheReset(String tableName, int Record_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("TableName=" + tableName + ", Record_ID=" + Record_ID);
        }
        CacheMgt.get().reset(tableName, Record_ID);
    }

    public static void actionRefresh(Lookup lookup, Object value, boolean mandatory, boolean shortList) {
        if (lookup == null) {
            return;
        }
        lookup.refresh();
        if (lookup.isValidated()) {
            lookup.fillComboBox(mandatory, false, false, false, shortList);
        } else {
            lookup.fillComboBox(mandatory, true, false, false, shortList);
        }
    }

    public static void actionZoom(Lookup lookup, Object value) {
        MReference reference;
        int AD_Reference_ID;
        if (lookup == null) {
            return;
        }
        if (value == null) {
            value = -1;
        }
        MQuery zoomQuery = new MQuery();
        String column = lookup.getColumnName();
        if (lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)lookup).getAD_Reference_Value_ID()) > 0 && (reference = MReference.get((int)AD_Reference_ID)).getValidationType().equals("L")) {
            column = "AD_Ref_List_ID";
            value = DB.getSQLValue(null, (String)"SELECT AD_Ref_List_ID FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?", (Object[])new Object[]{AD_Reference_ID, value});
        }
        if (column.indexOf(".") > 0) {
            int p = column.indexOf(".");
            String tableName = column.substring(0, p);
            column = column.substring(column.indexOf(".") + 1);
            zoomQuery.setZoomTableName(tableName);
            zoomQuery.setZoomColumnName(column);
        } else {
            zoomQuery.setZoomColumnName(column);
            zoomQuery.setZoomTableName(column.substring(0, column.length() - 3));
        }
        zoomQuery.setZoomValue(value);
        zoomQuery.addRestriction(column, "=", value);
        zoomQuery.setRecordCount(1);
        int windowId = lookup.getZoom(zoomQuery);
        if (windowId > 0) {
            AEnv.zoom(windowId, zoomQuery, lookup.getWindowNo());
        } else {
            int tableId = MTable.getTable_ID((String)zoomQuery.getZoomTableName());
            if (value instanceof Integer && (Integer)value >= 0) {
                AEnv.zoom(tableId, (Integer)value, zoomQuery, lookup.getWindowNo());
            } else {
                AEnv.zoomUU(tableId, value.toString(), zoomQuery, lookup.getWindowNo());
            }
        }
    }

    public static void actionDrill(DrillEvent.DrillData data, int windowNo) {
        AEnv.actionDrill(data, windowNo, 0);
    }

    public static void actionDrill(DrillEvent.DrillData data, int windowNo, int processID) {
        int AD_Table_ID = MTable.getTable_ID((String)data.getQuery().getTableName());
        if (AD_Table_ID > 0) {
            if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
                Dialog.error(windowNo, "AccessCannotReport", data.getQuery().getTableName());
                return;
            }
            WDrillReport drillReport = new WDrillReport(data, windowNo, processID);
            Object window = SessionManager.getAppDesktop().findWindow(windowNo);
            if (window != null && window instanceof Component && window instanceof ISupportMask) {
                final ISupportMask parent = LayoutUtils.showWindowWithMask((org.zkoss.zul.Window)drillReport, (Component)window, 3);
                drillReport.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        parent.hideMask();
                    }
                });
            } else if (window != null && window instanceof Component) {
                final Mask mask = LayoutUtils.showWindowWithMask((org.zkoss.zul.Window)drillReport, (Component)window, null);
                drillReport.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        mask.hideMask();
                    }
                });
            } else {
                drillReport.setAttribute("mode", "highlighted");
                AEnv.showWindow(drillReport);
            }
        } else {
            log.warning("No Table found for " + data.getQuery().getWhereClause(true));
        }
    }

    public static void showZoomWindow(int AD_Window_ID, MQuery query) {
        SessionManager.getAppDesktop().showZoomWindow(AD_Window_ID, query);
    }

    public static void zoom(int AD_Window_ID, MQuery query, int windowNo) {
        int zoomId = MZoomCondition.findZoomWindowByWindowId((int)AD_Window_ID, (MQuery)query, (int)windowNo);
        AEnv.showZoomWindow(zoomId > 0 ? zoomId : AD_Window_ID, query);
    }

    public static void zoom(int AD_Window_ID, MQuery query) {
        AEnv.zoom(AD_Window_ID, query, 0);
    }

    public static void showWindow(Window win) {
        SessionManager.getAppDesktop().showWindow(win);
    }

    public static void zoom(MQuery query) {
        if (query == null || query.getTableName() == null || query.getTableName().length() == 0) {
            return;
        }
        int AD_Window_ID = query.getZoomWindowID();
        if (AD_Window_ID <= 0) {
            AD_Window_ID = Env.getZoomWindowID((MQuery)query);
        }
        if (AD_Window_ID == 0) {
            return;
        }
        AEnv.showZoomWindow(AD_Window_ID, query);
    }

    public static URI getImage(String fileNameInImageDir) {
        URI uri = null;
        try {
            uri = new URI(ThemeManager.getThemeResource("images/" + fileNameInImageDir));
        }
        catch (URISyntaxException uRISyntaxException) {
            log.log(Level.SEVERE, "Not found: " + fileNameInImageDir);
            return null;
        }
        return uri;
    }

    public static boolean isFirefox2() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return false;
        }
        Object n = execution.getNativeRequest();
        if (n instanceof ServletRequest) {
            String userAgent = Servlets.getUserAgent((ServletRequest)((ServletRequest)n));
            return userAgent.indexOf("Firefox/2") >= 0;
        }
        return false;
    }

    public static boolean isBrowserSupported() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return false;
        }
        Object n = execution.getNativeRequest();
        if (n instanceof ServletRequest) {
            Double version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"ff");
            if (version != null) {
                return true;
            }
            version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"chrome");
            if (version != null) {
                return true;
            }
            version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"webkit");
            if (version != null) {
                return true;
            }
            version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"ie");
            if (version != null && version.intValue() >= 8) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInternetExplorer() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return false;
        }
        Object n = execution.getNativeRequest();
        if (n instanceof ServletRequest) {
            String browser = Servlets.getBrowser((ServletRequest)((ServletRequest)n));
            return browser != null && browser.equals("ie");
        }
        return false;
    }

    public static boolean contains(Component parent, Component child) {
        if (child == parent) {
            return true;
        }
        Component c = child.getParent();
        while (c != null) {
            if (c == parent) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public static void mergePdf(List<File> pdfList, File outFile) throws IOException, DocumentException, FileNotFoundException {
        Util.mergePdf(pdfList, (File)outFile);
    }

    public static String getWindowHeader(Properties ctx, int WindowNo) {
        StringBuilder sb = new StringBuilder();
        if (WindowNo > 0) {
            sb.append(Env.getContext((Properties)ctx, (int)WindowNo, (String)"_WinInfo_WindowName", (boolean)false)).append("  ");
            String documentNo = Env.getContext((Properties)ctx, (int)WindowNo, (String)"DocumentNo", (boolean)false);
            String value = Env.getContext((Properties)ctx, (int)WindowNo, (String)"Value", (boolean)false);
            String name = Env.getContext((Properties)ctx, (int)WindowNo, (String)"Name", (boolean)false);
            if (!"".equals(documentNo)) {
                sb.append(documentNo).append("  ");
            }
            if (!"".equals(value)) {
                sb.append(value).append("  ");
            }
            if (!"".equals(name)) {
                sb.append(name).append("  ");
            }
        }
        return sb.toString();
    }

    public static Language getLanguage(Properties ctx) {
        return Env.getLocaleLanguage((Properties)ctx);
    }

    public static Locale getLocale(Properties ctx) {
        return Env.getLocale((Properties)ctx);
    }

    public static String getDialogHeader(Properties ctx, int windowNo, String prefix) {
        String header;
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (windowNo > 0) {
            String name;
            String value;
            sb.append(Env.getContext((Properties)ctx, (int)windowNo, (String)"_WinInfo_WindowName", (boolean)false)).append(": ");
            String documentNo = Env.getContext((Properties)ctx, (int)windowNo, (String)"DocumentNo", (boolean)false);
            if (Util.isEmpty((String)documentNo)) {
                documentNo = Env.getContext((Properties)ctx, (int)windowNo, (int)0, (String)"DocumentNo", (boolean)false);
            }
            if (Util.isEmpty((String)(value = Env.getContext((Properties)ctx, (int)windowNo, (String)"Value", (boolean)false)))) {
                value = Env.getContext((Properties)ctx, (int)windowNo, (int)0, (String)"Value", (boolean)false);
            }
            if (Util.isEmpty((String)(name = Env.getContext((Properties)ctx, (int)windowNo, (String)"Name", (boolean)false)))) {
                name = Env.getContext((Properties)ctx, (int)windowNo, (int)0, (String)"Name", (boolean)false);
            }
            if (!"".equals(documentNo)) {
                sb.append(documentNo).append("  ");
            }
            if (!"".equals(value)) {
                sb.append(value).append("  ");
            }
            if (!"".equals(name)) {
                sb.append(name).append("  ");
            }
        }
        if ((header = sb.toString().trim()).length() == 0) {
            header = ThemeManager.getBrowserTitle();
        }
        if (header.endsWith(":")) {
            header = header.substring(0, header.length() - 1);
        }
        return header;
    }

    public static String getDialogHeader(Properties ctx, int windowNo) {
        return AEnv.getDialogHeader(ctx, windowNo, null);
    }

    public static void executeDesktopTask(final Runnable runnable) {
        Desktop desktop = AEnv.getDesktop();
        ServerPushTemplate template = new ServerPushTemplate(desktop);
        template.execute(new IServerPushCallback(){

            @Override
            public void updateUI() {
                runnable.run();
            }
        });
    }

    public static void executeAsyncDesktopTask(final Runnable runnable) {
        Desktop desktop = AEnv.getDesktop();
        ServerPushTemplate template = new ServerPushTemplate(desktop);
        template.executeAsync(new IServerPushCallback(){

            @Override
            public void updateUI() {
                runnable.run();
            }
        });
    }

    public static Desktop getDesktop() {
        boolean inUIThread;
        boolean bl = inUIThread = Executions.getCurrent() != null;
        if (inUIThread) {
            return Executions.getCurrent().getDesktop();
        }
        WeakReference<Desktop> ref = DesktopRunnable.getThreadLocalDesktop();
        return ref != null ? (Desktop)ref.get() : null;
    }

    @Deprecated(forRemoval=true, since="11")
    public static boolean isTablet() {
        return ClientInfo.isMobile();
    }

    public static int getADWindowID(int windowNo) {
        int adWindowID = 0;
        Object window = SessionManager.getAppDesktop().findWindow(windowNo);
        if (window != null && window instanceof ADWindow) {
            adWindowID = ((ADWindow)window).getAD_Window_ID();
        } else if (window != null && (window instanceof ProcessDialog || window instanceof InfoWindow)) {
            adWindowID = Env.adWindowDummyID;
        }
        return adWindowID;
    }

    public static WTableDirEditor getListDocumentLanguage(MClient client) throws Exception {
        WTableDirEditor fLanguageType = null;
        if (client.isMultiLingualDocument()) {
            MLookup lookupLanguage = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"AD_Language_ID", (int)0, (boolean)false, (String)" IsActive='Y' AND IsLoginLocale = 'Y' ");
            fLanguageType = new WTableDirEditor("AD_Language_ID", false, false, true, (Lookup)lookupLanguage);
        }
        return fLanguageType;
    }

    public static String getApplicationUrl() {
        String url = MSysConfig.getValue((String)"APPLICATION_URL", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (!Util.isEmpty((String)url) && !url.equals("USE_HARDCODED")) {
            return MSysConfig.getValue((String)"APPLICATION_URL", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        }
        if (m_ApplicationUrl != null) {
            return m_ApplicationUrl;
        }
        int port = Executions.getCurrent().getServerPort();
        String sch = Executions.getCurrent().getScheme();
        Object sport = null;
        sport = sch.equals("http") && port == 80 || sch.equals("https") && port == 443 ? "" : ":" + port;
        m_ApplicationUrl = sch + "://" + Executions.getCurrent().getServerName() + (String)sport + Executions.getCurrent().getContextPath() + Executions.getCurrent().getDesktop().getRequestPath();
        return m_ApplicationUrl;
    }

    public static String getZoomUrlTableUU(PO po) {
        return AEnv.getApplicationUrl() + "?Action=Zoom&TableName=" + po.get_TableName() + "&Record_UU=" + po.get_UUID();
    }

    public static String getZoomUrlTableID(PO po) {
        return AEnv.getApplicationUrl() + "?Action=Zoom&TableName=" + po.get_TableName() + "&Record_ID=" + po.get_ID();
    }

    public static String getZoomUrlTableName(PO po) {
        return AEnv.getApplicationUrl() + "?Action=Zoom&TableName" + po.get_TableName() + "&Record_ID=" + po.get_ID();
    }

    public static boolean getOrSetExecutionAttribute(String attribute) {
        if (Executions.getCurrent() != null) {
            if (Executions.getCurrent().getAttribute(attribute) != null) {
                return true;
            }
            Executions.getCurrent().setAttribute(attribute, (Object)Boolean.TRUE);
        }
        return false;
    }

    public static void detachInputElement(Component parent) {
        if (parent instanceof InputElement || parent instanceof Button) {
            parent.detach();
        }
        if (parent.getChildren().size() > 0) {
            Component[] childs;
            Component[] componentArray = childs = parent.getChildren().toArray(new Component[0]);
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                AEnv.detachInputElement(child);
                ++n2;
            }
        }
    }

    public static String toPdfJsUrl(String pdfUrl) {
        String viewer = Executions.encodeURL((String)"~./js/pdf.js/web/viewer.html?file=");
        int index = viewer.indexOf("/zkau");
        if (index >= 0) {
            viewer = viewer.substring(index + 1);
        }
        StringBuilder url = new StringBuilder(viewer);
        url.append(pdfUrl);
        return url.toString();
    }
}

