/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.MAttachment;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AttachmentElementHandler
extends AbstractElementHandler {
    private List<Integer> attachments = new ArrayList<Integer>();

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        MAttachment mAttachment = (MAttachment)this.findPO(ctx, element);
        if (mAttachment == null) {
            mAttachment = new MAttachment(ctx.ctx, 0, this.getTrxName(ctx));
        }
        List excludes = this.defaultExcludeList("AD_Attachment");
        if (this.attachments.contains(mAttachment.getAD_Attachment_ID())) {
            element.skip = true;
            return;
        }
        PoFiller pf = new PoFiller(ctx, (PO)mAttachment, element, (AbstractElementHandler)this);
        List notfounds = pf.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        mAttachment.getEntries();
        if (mAttachment.is_new() || mAttachment.is_Changed()) {
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Attachment", 254);
            if (!mAttachment.is_new()) {
                this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Attachment", (PO)mAttachment);
                action = "Update";
            } else {
                action = "New";
            }
            if (mAttachment.save(this.getTrxName(ctx))) {
                this.logImportDetail(ctx, impDetail, 1, mAttachment.toString(), mAttachment.get_ID(), action);
                element.recordId = mAttachment.getAD_Attachment_ID();
                this.attachments.add(mAttachment.getAD_Attachment_ID());
            } else {
                this.logImportDetail(ctx, impDetail, 0, mAttachment.toString(), mAttachment.get_ID(), action);
                throw new POSaveFailedException("Failed to save Attachment " + mAttachment.toString());
            }
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    protected void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Attachment_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Attachment_ID");
        if (ctx.packOut.isExported("AD_Attachment_ID|" + AD_Attachment_ID)) {
            return;
        }
        MAttachment mAttachment = new MAttachment(ctx.ctx, AD_Attachment_ID, this.getTrxName(ctx));
        if (!this.isPackOutElement(ctx, (PO)mAttachment)) {
            return;
        }
        this.verifyPackOutRequirement((PO)mAttachment);
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_Attachment", atts);
        this.createAttachmentBinding(ctx, document, mAttachment);
        int[] ids = PO.getAllIDs((String)"AD_AttachmentNote", (String)("AD_Attachment_ID=" + AD_Attachment_ID), (String)this.getTrxName(ctx));
        if (ids != null && ids.length > 0) {
            ElementHandler handler = ctx.packOut.getHandler("AD_AttachmentNote");
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int AD_AttachmentNote_ID = nArray[n2];
                try {
                    handler.packOut(ctx.packOut, document, null, AD_AttachmentNote_ID);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
                ++n2;
            }
        }
        document.endElement("", "", "AD_Attachment");
    }

    private void createAttachmentBinding(PIPOContext ctx, TransformerHandler document, MAttachment mAttachment) {
        PoExporter filler = new PoExporter(ctx, document, (PO)mAttachment);
        if (mAttachment.getAD_Attachment_ID() <= 999999) {
            filler.add("AD_Attachment_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList("AD_Attachment");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        packout.getCtx().ctx.put("AD_Attachment_ID", Integer.toString(recordId));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Attachment_ID");
    }
}

