/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.model;

import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MAssetDisposed;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.idempiere.fa.exceptions.AssetProductStockedException;

public class ModelValidator
implements org.compiere.model.ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(ModelValidator.class);
    private int m_AD_Client_ID = -1;

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_InvoiceLine", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addModelChange("M_MatchInv", this);
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MMatchInv && (4 == type || 5 == type && po.is_ValueChanged("Processed"))) {
            MInvoiceLine invoiceLine;
            MMatchInv mi = (MMatchInv)po;
            if (mi.isProcessed() && (invoiceLine = new MInvoiceLine(mi.getCtx(), mi.getC_InvoiceLine_ID(), mi.get_TrxName())).isA_CreateAsset() && !invoiceLine.isA_Processed()) {
                MAssetAddition.createAsset(mi);
            }
        } else if (po instanceof MInvoiceLine) {
            this.modelChange_InvoiceLine(SetGetUtil.wrap(po), type);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice mi;
        if (log.isLoggable(Level.INFO)) {
            log.info(po.get_TableName() + " Timing: " + timing);
        }
        String result = null;
        String tableName = po.get_TableName();
        if (tableName.equals("C_Invoice") && timing == 9 && (mi = (MInvoice)po).isSOTrx()) {
            MInvoiceLine[] mils;
            MInvoiceLine[] mInvoiceLineArray = mils = mi.getLines();
            int n = mils.length;
            int n2 = 0;
            while (n2 < n) {
                MInvoiceLine mil = mInvoiceLineArray[n2];
                if (mil.isA_CreateAsset() && !mil.isA_Processed()) {
                    MAssetDisposed.createAssetDisposed(mil);
                }
                ++n2;
            }
        }
        return result;
    }

    public void modelChange_InvoiceLine(SetGetModel m, int changeType) {
        int invoice_id;
        if (-1 == changeType || 1 == changeType || 2 == changeType) {
            invoice_id = SetGetUtil.get_AttrValueAsInt(m, "C_Invoice_ID");
            DB.isSOTrx("C_Invoice", "C_Invoice_ID=" + invoice_id);
            boolean isAsset = false;
            int assetGroup_ID = 0;
            int product_id = SetGetUtil.get_AttrValueAsInt(m, "M_Product_ID");
            if (product_id > 0) {
                MProduct prod = MProduct.get(m.getCtx(), product_id);
                isAsset = prod != null && prod.get_ID() > 0 && prod.isCreateAsset();
                assetGroup_ID = prod != null ? prod.getA_Asset_Group_ID() : 0;
            }
            m.set_AttrValue("A_CreateAsset", isAsset);
            if (isAsset) {
                m.set_AttrValue("A_Asset_Group_ID", assetGroup_ID);
                m.set_AttrValue("IsFixedAssetInvoice", isAsset);
                m.set_AttrValue("A_CreateAsset", "Y");
            } else {
                m.set_AttrValue("A_Asset_Group_ID", null);
                m.set_AttrValue("A_Asset_ID", null);
                m.set_AttrValue("IsFixedAssetInvoice", false);
            }
            if (isAsset && m instanceof MInvoiceLine) {
                MInvoiceLine line = (MInvoiceLine)((Object)m);
                if ("Exp".equals(line.getA_CapvsExp()) && line.getA_Asset_ID() <= 0) {
                    throw new FillMandatoryException(new String[]{"A_Asset_ID"});
                }
                if (line.getLineNetAmt().signum() == 0) {
                    throw new FillMandatoryException("QtyEntered", "PriceEntered");
                }
                MProduct product = line.getProduct();
                if (product.isStocked() && line.isFixedAssetInvoice()) {
                    throw new AssetProductStockedException(product);
                }
            }
        }
        if (4 == changeType || 5 == changeType || 6 == changeType) {
            invoice_id = SetGetUtil.get_AttrValueAsInt(m, "C_Invoice_ID");
            String sql = "UPDATE C_Invoice i SET IsFixedAssetInvoice=(SELECT COALESCE(MAX(il.IsFixedAssetInvoice),'N') FROM C_InvoiceLine il WHERE il.C_Invoice_ID=i.C_Invoice_ID AND il.IsDescription='N') WHERE C_Invoice_ID=?";
            DB.executeUpdateEx(sql, new Object[]{invoice_id}, m.get_TrxName());
        }
    }

    @Override
    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        return null;
    }
}

