/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.net.MediaType;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.print.export.PrintDataXLSXExporter;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.XLSReportRenderer;
import org.idempiere.print.renderer.XLSXReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class XLSXReportRenderer
implements IReportRenderer<XLSXReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(XLSReportRenderer.class);

    @Override
    public String getId() {
        return "XLSX";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileXLSX");
    }

    @Override
    public String getContentType() {
        return MediaType.OOXML_SHEET.toString();
    }

    @Override
    public String getFileExtension() {
        return "xlsx";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, XLSXReportRendererConfiguration configuration) {
        try {
            this.createXLSX(reportEngine, configuration.getOutputFile(), configuration.getLanguage());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new AdempiereException(e);
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    private void createXLSX(ReportEngine reportEngine, File outFile, Language language) throws Exception {
        LayoutEngine layout = reportEngine.getLayout();
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(printFormat) : layout.colSuppressRepeats;
        Map<MPrintFormatItem, PrintData> childFormats = layout != null ? layout.getChildPrintFormatDetails() : null;
        PrintDataXLSXExporter exp = new PrintDataXLSXExporter(reportEngine.getPrintData(), printFormat, childFormats, colSuppressRepeats, reportEngine.getQuery());
        exp.export(outFile, language);
    }

    @Override
    public Class<XLSXReportRendererConfiguration> getConfigurationType() {
        return XLSXReportRendererConfiguration.class;
    }
}

